/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace;

import java.util.Arrays;
import java.util.List;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.workspace.internal.DefaultGradleClasspathContainer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;

public abstract class GradleClasspathContainer
implements IClasspathContainer {
    public static final Path CONTAINER_PATH = new Path("org.eclipse.buildship.core.gradleclasspathcontainer");

    public static IClasspathContainer newInstance(List<IClasspathEntry> classpathEntries) {
        return new DefaultGradleClasspathContainer((IPath)CONTAINER_PATH, classpathEntries);
    }

    public static void addIfNotPresent(IJavaProject javaProject, IProgressMonitor progress) throws JavaModelException {
        IClasspathEntry[] oldClasspath;
        for (IClasspathEntry entry : oldClasspath = javaProject.getRawClasspath()) {
            if (!entry.getPath().equals((Object)CONTAINER_PATH)) continue;
            return;
        }
        IClasspathEntry[] newClasspath = new IClasspathEntry[oldClasspath.length + 1];
        System.arraycopy(oldClasspath, 0, newClasspath, 0, oldClasspath.length);
        newClasspath[newClasspath.length - 1] = GradleClasspathContainer.newClasspathEntry(new IClasspathAttribute[0]);
        javaProject.setRawClasspath(newClasspath, progress);
    }

    public static void updateAttributes(IJavaProject javaProject, IClasspathAttribute[] extraAttributes, SubMonitor progress) throws JavaModelException {
        Object[] oldClasspath = javaProject.getRawClasspath();
        Object[] newClasspath = new IClasspathEntry[oldClasspath.length];
        for (int i = 0; i < oldClasspath.length; ++i) {
            IClasspathEntry entry = oldClasspath[i];
            if (entry.getPath().equals((Object)CONTAINER_PATH)) {
                IClasspathEntry newContainer = GradleClasspathContainer.newClasspathEntry(extraAttributes);
                newClasspath[i] = newContainer;
                continue;
            }
            newClasspath[i] = entry;
        }
        if (!Arrays.equals(oldClasspath, newClasspath)) {
            javaProject.setRawClasspath((IClasspathEntry[])newClasspath, (IProgressMonitor)progress);
        }
    }

    private static IClasspathEntry newClasspathEntry(IClasspathAttribute ... extraAttributes) throws JavaModelException {
        return JavaCore.newContainerEntry((IPath)CONTAINER_PATH, null, (IClasspathAttribute[])extraAttributes, (boolean)false);
    }

    public static void requestUpdateOf(IJavaProject project) {
        ClasspathContainerInitializer initializer = JavaCore.getClasspathContainerInitializer((String)CONTAINER_PATH.toString());
        try {
            initializer.requestClasspathContainerUpdate((IPath)CONTAINER_PATH, project, null);
        }
        catch (CoreException e) {
            throw new GradlePluginsRuntimeException(e);
        }
    }
}

