/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view.execution;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import org.eclipse.buildship.ui.external.viewer.FilteredTree;
import org.eclipse.buildship.ui.i18n.UiMessages;
import org.eclipse.buildship.ui.view.MultiPageView;
import org.eclipse.buildship.ui.view.TreeViewerState;
import org.eclipse.buildship.ui.view.execution.ExecutionPage;
import org.eclipse.jface.action.Action;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;

public final class ToggleShowTreeHeaderAction
extends Action {
    private final MultiPageView multiPageView;
    private final TreeViewerState treeViewerState;

    public ToggleShowTreeHeaderAction(MultiPageView multiPageView, TreeViewerState treeViewerState) {
        super(null, 2);
        this.multiPageView = (MultiPageView)((Object)Preconditions.checkNotNull((Object)((Object)multiPageView)));
        this.treeViewerState = (TreeViewerState)Preconditions.checkNotNull((Object)treeViewerState);
        this.setText(UiMessages.Action_ShowTreeHeader_Text);
        this.setChecked(this.treeViewerState.isShowTreeHeader());
        this.updateHeaderVisibility();
    }

    public void run() {
        this.treeViewerState.setShowTreeHeader(this.isChecked());
        this.updateHeaderVisibility();
    }

    private void updateHeaderVisibility() {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                boolean showTreeHeader = ToggleShowTreeHeaderAction.this.treeViewerState.isShowTreeHeader();
                for (ExecutionPage executionPage : FluentIterable.from(ToggleShowTreeHeaderAction.this.multiPageView.getPages()).filter(ExecutionPage.class)) {
                    Tree tree = ((FilteredTree)((Object)executionPage.getPageControl())).getViewer().getTree();
                    if (tree.isDisposed()) continue;
                    tree.setHeaderVisible(showTreeHeader);
                }
            }
        });
    }
}

