/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.wizard.project;

import com.google.common.util.concurrent.FutureCallback;
import com.gradleware.tooling.toolingmodel.OmniBuildEnvironment;
import com.gradleware.tooling.toolingmodel.OmniGradleBuildStructure;
import com.gradleware.tooling.toolingmodel.util.Pair;
import java.util.List;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.projectimport.ProjectImportConfiguration;
import org.eclipse.buildship.core.projectimport.ProjectPreviewJob;
import org.eclipse.buildship.core.util.gradle.PublishedGradleVersionsWrapper;
import org.eclipse.buildship.core.util.progress.AsyncHandler;
import org.eclipse.buildship.ui.UiPlugin;
import org.eclipse.buildship.ui.util.workbench.WorkingSetUtils;
import org.eclipse.buildship.ui.wizard.project.GradleOptionsWizardPage;
import org.eclipse.buildship.ui.wizard.project.GradleProjectWizardPage;
import org.eclipse.buildship.ui.wizard.project.GradleWelcomeWizardPage;
import org.eclipse.buildship.ui.wizard.project.HelpContextIdProvider;
import org.eclipse.buildship.ui.wizard.project.ProjectImportWizardController;
import org.eclipse.buildship.ui.wizard.project.ProjectPreviewWizardPage;
import org.eclipse.buildship.ui.wizard.project.ProjectWizardMessages;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;
import org.gradle.tooling.ProgressListener;
import org.osgi.service.prefs.BackingStoreException;

public final class ProjectImportWizard
extends Wizard
implements IImportWizard,
HelpContextIdProvider {
    private static final String PROJECT_IMPORT_DIALOG_SETTINGS = "org.eclipse.buildship.ui.wizard.project.import";
    private static final String PREF_SHOW_WELCOME_PAGE = "org.eclipse.buildship.ui.wizard.project.import.showWelcomePage";
    private final GradleWelcomeWizardPage welcomeWizardPage;
    private final GradleProjectWizardPage gradleProjectPage;
    private final GradleOptionsWizardPage gradleOptionsPage;
    private final ProjectPreviewWizardPage projectPreviewPage;
    private final ProjectImportWizardController controller;
    private boolean finishGloballyEnabled;

    public ProjectImportWizard() {
        this(ProjectImportWizard.getOrCreateDialogSection(UiPlugin.getInstance().getDialogSettings()), CorePlugin.publishedGradleVersions());
    }

    public ProjectImportWizard(IDialogSettings dialogSettings, PublishedGradleVersionsWrapper publishedGradleVersions) {
        this.setDialogSettings(dialogSettings);
        this.controller = new ProjectImportWizardController((IWizard)this);
        final ProjectImportConfiguration configuration = this.controller.getConfiguration();
        this.welcomeWizardPage = new GradleWelcomeWizardPage(configuration);
        this.gradleProjectPage = new GradleProjectWizardPage(configuration);
        this.gradleOptionsPage = new GradleOptionsWizardPage(configuration, publishedGradleVersions);
        this.projectPreviewPage = new ProjectPreviewWizardPage(this.controller.getConfiguration(), new ProjectPreviewWizardPage.ProjectPreviewLoader(){

            @Override
            public Job loadPreview(FutureCallback<Pair<OmniBuildEnvironment, OmniGradleBuildStructure>> resultHandler, List<ProgressListener> listeners) {
                ProjectPreviewJob projectPreviewJob = new ProjectPreviewJob(configuration, listeners, AsyncHandler.NO_OP, resultHandler);
                projectPreviewJob.schedule();
                return projectPreviewJob;
            }
        });
        this.finishGloballyEnabled = true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        List<String> workingSetNames = WorkingSetUtils.getSelectedWorkingSetNames(selection);
        if (!workingSetNames.isEmpty()) {
            this.controller.getConfiguration().setApplyWorkingSets(Boolean.valueOf(true));
            this.controller.getConfiguration().setWorkingSets(workingSetNames);
        }
    }

    public String getWindowTitle() {
        return ProjectWizardMessages.Title_GradleProjectWizardPage;
    }

    public void addPages() {
        if (this.isShowWelcomePage()) {
            this.addPage((IWizardPage)this.welcomeWizardPage);
        }
        this.addPage((IWizardPage)this.gradleProjectPage);
        this.addPage((IWizardPage)this.gradleOptionsPage);
        this.addPage((IWizardPage)this.projectPreviewPage);
        this.setNeedsProgressMonitor(true);
        this.setHelpAvailable(true);
    }

    public boolean isShowWelcomePage() {
        ConfigurationScope configurationScope = new ConfigurationScope();
        IEclipsePreferences node = configurationScope.getNode("org.eclipse.buildship.ui");
        return node.getBoolean(PREF_SHOW_WELCOME_PAGE, true);
    }

    public void setWelcomePageEnabled(boolean value) {
        ConfigurationScope configurationScope = new ConfigurationScope();
        IEclipsePreferences node = configurationScope.getNode("org.eclipse.buildship.ui");
        node.putBoolean(PREF_SHOW_WELCOME_PAGE, value);
        try {
            node.flush();
        }
        catch (BackingStoreException e) {
            throw new GradlePluginsRuntimeException((Exception)((Object)e));
        }
    }

    public boolean performFinish() {
        return this.controller.performImportProject(AsyncHandler.NO_OP);
    }

    public boolean canFinish() {
        return super.canFinish() && this.finishGloballyEnabled;
    }

    public void setFinishGloballyEnabled(boolean finishGloballyEnabled) {
        this.finishGloballyEnabled = finishGloballyEnabled;
    }

    @Override
    public String getHelpContextId() {
        return "org.eclipse.buildship.ui.projectimport";
    }

    private static IDialogSettings getOrCreateDialogSection(IDialogSettings dialogSettings) {
        IDialogSettings section = dialogSettings.getSection(PROJECT_IMPORT_DIALOG_SETTINGS);
        if (section == null) {
            section = dialogSettings.addNewSection(PROJECT_IMPORT_DIALOG_SETTINGS);
        }
        return section;
    }
}

