/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.view.task;

import com.google.common.base.Optional;
import org.eclipse.buildship.ui.PluginImage;
import org.eclipse.buildship.ui.PluginImages;
import org.eclipse.buildship.ui.util.nodeselection.NodeSelection;
import org.eclipse.buildship.ui.view.task.FaultyProjectNode;
import org.eclipse.buildship.ui.view.task.ProjectNode;
import org.eclipse.buildship.ui.view.task.ProjectTaskNode;
import org.eclipse.buildship.ui.view.task.TaskGroupNode;
import org.eclipse.buildship.ui.view.task.TaskNode;
import org.eclipse.buildship.ui.view.task.TaskSelectorNode;
import org.eclipse.buildship.ui.view.task.TaskViewActionStateRules;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public final class TaskNameLabelProvider
extends LabelProvider
implements DelegatingStyledCellLabelProvider.IStyledLabelProvider {
    public String getText(Object element) {
        return element == null ? "" : this.getStyledText(element).getString();
    }

    public StyledString getStyledText(Object element) {
        if (element instanceof ProjectTaskNode) {
            return this.getProjectTaskText((ProjectTaskNode)element);
        }
        if (element instanceof TaskSelectorNode) {
            return this.getTaskSelectorText((TaskSelectorNode)element);
        }
        if (element instanceof ProjectNode) {
            return this.getProjectText((ProjectNode)element);
        }
        if (element instanceof TaskGroupNode) {
            return this.getGroupText((TaskGroupNode)element);
        }
        if (element instanceof FaultyProjectNode) {
            return new StyledString(((IProject)((FaultyProjectNode)element).getWorkspaceProject().get()).getName());
        }
        throw new IllegalStateException(String.format("Unknown element type of element %s.", element));
    }

    public Image getImage(Object element) {
        if (element instanceof ProjectTaskNode) {
            return this.getProjectTaskImage((ProjectTaskNode)element);
        }
        if (element instanceof TaskSelectorNode) {
            return this.getTaskSelectorImage((TaskSelectorNode)element);
        }
        if (element instanceof ProjectNode) {
            return this.getProjectImage((ProjectNode)element);
        }
        if (element instanceof FaultyProjectNode) {
            return this.getFaultyProjectImage((FaultyProjectNode)element);
        }
        if (element instanceof TaskGroupNode) {
            return this.getGroupImage((TaskGroupNode)element);
        }
        throw new IllegalStateException(String.format("Unknown element type of element %s.", element));
    }

    private StyledString getTaskSelectorText(TaskSelectorNode taskSelector) {
        return new StyledString(taskSelector.getTaskSelector().getName());
    }

    private StyledString getProjectTaskText(ProjectTaskNode projectTask) {
        return new StyledString(projectTask.getProjectTask().getName());
    }

    private StyledString getGroupText(TaskGroupNode group) {
        return new StyledString(group.getName());
    }

    private StyledString getProjectText(ProjectNode project) {
        Optional<IProject> workspaceProject = project.getWorkspaceProject();
        String name = workspaceProject.isPresent() ? ((IProject)workspaceProject.get()).getName() : project.getEclipseProject().getName();
        return new StyledString(name);
    }

    private Image getProjectImage(ProjectNode project) {
        Optional<IProject> workspaceProject = project.getWorkspaceProject();
        if (!workspaceProject.isPresent() || !((IProject)workspaceProject.get()).isOpen()) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT_CLOSED");
        }
        if (TaskNameLabelProvider.isJavaProject((IProject)workspaceProject.get())) {
            return PluginImages.JAVA_PROJECT.withState(PluginImage.ImageState.ENABLED).getImage();
        }
        return PluginImages.PROJECT.withState(PluginImage.ImageState.ENABLED).getImage();
    }

    private static boolean isJavaProject(IProject project) {
        try {
            return project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException e) {
            return false;
        }
    }

    private Image getFaultyProjectImage(FaultyProjectNode node) {
        return PluginImages.FAULTY_PROJECT.withState(PluginImage.ImageState.ENABLED).getImage();
    }

    private Image getGroupImage(TaskGroupNode element) {
        return PluginImages.TASK_GROUP.withState(PluginImage.ImageState.ENABLED).getImage();
    }

    private Image getProjectTaskImage(ProjectTaskNode projectTask) {
        PluginImages image = projectTask.isPublic() ? PluginImages.PROJECT_TASK : PluginImages.PRIVATE_PROJECT_TASK;
        return image.withState(this.getImageState(projectTask)).getImage();
    }

    private Image getTaskSelectorImage(TaskSelectorNode taskSelector) {
        PluginImages image = taskSelector.isPublic() ? PluginImages.TASK : PluginImages.PRIVATE_TASK;
        return image.withState(this.getImageState(taskSelector)).getImage();
    }

    private PluginImage.ImageState getImageState(TaskNode taskNode) {
        return TaskViewActionStateRules.taskScopedTaskExecutionActionsEnablement(NodeSelection.single(taskNode)).asBoolean() ? PluginImage.ImageState.ENABLED : PluginImage.ImageState.DISABLED;
    }
}

