/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.launch;

import com.google.common.base.Optional;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.configuration.RunConfiguration;
import org.eclipse.buildship.ui.internal.UiPlugin;
import org.eclipse.buildship.ui.internal.util.workbench.WorkbenchUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.ui.PlatformUI;

public final class ConsoleShowingLaunchListener
implements ILaunchListener {
    public void launchAdded(ILaunch launch) {
        Optional<RunConfiguration> attributes = this.convertToGradleRunConfigurationAttributes(launch);
        if (attributes.isPresent() && ((RunConfiguration)attributes.get()).isShowConsoleView()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(this){

                @Override
                public void run() {
                    WorkbenchUtils.showView("org.eclipse.ui.console.ConsoleView", null, 1);
                }
            });
        }
    }

    private Optional<RunConfiguration> convertToGradleRunConfigurationAttributes(ILaunch launch) {
        ILaunchConfigurationType type;
        ILaunchConfiguration launchConfiguration = launch.getLaunchConfiguration();
        if (launchConfiguration == null) {
            return Optional.absent();
        }
        try {
            type = launchConfiguration.getType();
        }
        catch (CoreException e) {
            UiPlugin.logger().error("Unable to determine launch configuration type", (Throwable)e);
            return Optional.absent();
        }
        if ("org.eclipse.buildship.core.launch.runconfiguration".equals(type.getIdentifier())) {
            return Optional.of((Object)CorePlugin.configurationManager().loadRunConfiguration(launchConfiguration));
        }
        return Optional.absent();
    }

    public void launchRemoved(ILaunch launch) {
    }

    public void launchChanged(ILaunch launch) {
    }

    public void handleAlreadyRunningLaunches() {
        for (ILaunch launch : DebugPlugin.getDefault().getLaunchManager().getLaunches()) {
            if (launch.isTerminated()) continue;
            this.launchAdded(launch);
        }
    }
}

