/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.dcl.provider;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.lsp4e.server.ProcessStreamConnectionProvider;
import org.eclipse.lsp4e.server.StreamConnectionProvider;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class DeclarativeGradleConnectionProvider
extends ProcessStreamConnectionProvider
implements StreamConnectionProvider {
    private static ILog log;

    public static ILog getLog() {
        if (log == null) {
            Bundle bundle = FrameworkUtil.getBundle(DeclarativeGradleConnectionProvider.class);
            log = Platform.getLog((Bundle)bundle);
        }
        return log;
    }

    public DeclarativeGradleConnectionProvider() {
        Bundle bundle = FrameworkUtil.getBundle(DeclarativeGradleConnectionProvider.class);
        try {
            URL localFileURL = FileLocator.toFileURL((URL)bundle.getEntry("/"));
            Path pathToPlugin = Paths.get(localFileURL.toURI());
            String lspJarPath = CorePlugin.configurationManager().loadWorkspaceConfiguration().getLspJarPath();
            if (lspJarPath.isBlank()) {
                throw new RuntimeException("LSP JAR path is not set!");
            }
            IExecutionEnvironment[] executionEnvironments = JavaRuntime.getExecutionEnvironmentsManager().getExecutionEnvironments();
            IExecutionEnvironment java11Environment = null;
            for (IExecutionEnvironment environment : executionEnvironments) {
                if (!environment.getId().equals("JavaSE-11")) continue;
                java11Environment = environment;
                break;
            }
            ArrayList<IVMInstall> compatibleJVMs = new ArrayList<IVMInstall>(Arrays.asList(java11Environment.getCompatibleVMs()));
            IVMInstall defaultVMInstall = JavaRuntime.getDefaultVMInstall();
            IVMInstall javaExecutable = null;
            if (!compatibleJVMs.isEmpty()) {
                javaExecutable = compatibleJVMs.contains(defaultVMInstall) ? defaultVMInstall : compatibleJVMs.get(0);
                String pathToJavaExecutable = javaExecutable.getInstallLocation().toPath().resolve("bin").resolve("java").toString();
                List<String> commands = Arrays.asList(pathToJavaExecutable, "-jar", lspJarPath);
                this.setCommands(commands);
                this.setWorkingDirectory(pathToPlugin.toString());
                System.out.println("Starting server with commands: " + String.valueOf(commands));
            } else {
                PlatformUI.getWorkbench().getDisplay().syncExec(new Runnable(this){

                    @Override
                    public void run() {
                        Shell shell = new Shell();
                        MessageBox messageBox = new MessageBox(shell, 40);
                        messageBox.setText("Error");
                        messageBox.setMessage("Compatible version of Java isn't found! Install and rerun application.");
                        messageBox.open();
                        shell.dispose();
                    }
                });
            }
        }
        catch (IOException | URISyntaxException e) {
            System.err.println("[GradlePropertiesConnectionProvider]:" + e.toString());
            e.printStackTrace();
        }
    }
}

