/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.workspace;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.buildship.core.BuildConfiguration;
import org.eclipse.buildship.core.GradleBuild;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.DefaultGradleBuild;
import org.eclipse.buildship.core.internal.configuration.GradleProjectNature;
import org.eclipse.buildship.core.internal.configuration.ProjectConfiguration;
import org.eclipse.buildship.core.internal.workspace.InternalGradleBuild;
import org.eclipse.buildship.core.internal.workspace.InternalGradleWorkspace;
import org.eclipse.core.resources.IProject;

public final class DefaultGradleWorkspace
implements InternalGradleWorkspace {
    private final LoadingCache<org.eclipse.buildship.core.internal.configuration.BuildConfiguration, InternalGradleBuild> cache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<org.eclipse.buildship.core.internal.configuration.BuildConfiguration, InternalGradleBuild>(this){

        public InternalGradleBuild load(org.eclipse.buildship.core.internal.configuration.BuildConfiguration buildConfiguration) {
            return new DefaultGradleBuild(buildConfiguration);
        }
    });

    @Override
    public InternalGradleBuild getGradleBuild(org.eclipse.buildship.core.internal.configuration.BuildConfiguration buildConfig) {
        return (InternalGradleBuild)this.cache.getUnchecked((Object)buildConfig);
    }

    @Override
    public Set<InternalGradleBuild> getGradleBuilds() {
        return CorePlugin.workspaceOperations().getAllProjects().stream().filter(GradleProjectNature.isPresentOn()).map(project -> DefaultGradleWorkspace.toBuildConfigurationOrNull(project)).filter(Objects::nonNull).map(buildConfig -> this.getGradleBuild((org.eclipse.buildship.core.internal.configuration.BuildConfiguration)buildConfig)).collect(Collectors.toSet());
    }

    @Override
    public Optional<GradleBuild> getBuild(IProject project) {
        ProjectConfiguration projectConfiguration;
        if (GradleProjectNature.isPresentOn(project) && (projectConfiguration = CorePlugin.configurationManager().tryLoadProjectConfiguration(project)) != null) {
            org.eclipse.buildship.core.internal.configuration.BuildConfiguration buildConfiguration = projectConfiguration.getBuildConfiguration();
            return Optional.of(this.getGradleBuild(buildConfiguration));
        }
        return Optional.empty();
    }

    @Override
    public GradleBuild createBuild(BuildConfiguration configuration) {
        Preconditions.checkNotNull((Object)configuration);
        return this.getGradleBuild(CorePlugin.configurationManager().createBuildConfiguration(configuration.getRootProjectDirectory(), configuration.isOverrideWorkspaceConfiguration(), configuration.getGradleDistribution(), configuration.getGradleUserHome().orElse(null), configuration.getJavaHome().orElse(null), configuration.isBuildScansEnabled(), configuration.isOfflineMode(), configuration.isAutoSync(), configuration.getArguments(), configuration.getJvmArguments(), configuration.isShowConsoleView(), configuration.isShowExecutionsView()));
    }

    private static org.eclipse.buildship.core.internal.configuration.BuildConfiguration toBuildConfigurationOrNull(IProject project) {
        ProjectConfiguration projectConfiguration = CorePlugin.configurationManager().tryLoadProjectConfiguration(project);
        return projectConfiguration != null ? projectConfiguration.getBuildConfiguration() : null;
    }
}

