/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.workspace;

import com.google.common.base.Strings;
import java.io.File;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.configuration.BuildConfiguration;
import org.eclipse.buildship.core.internal.configuration.ProjectConfiguration;
import org.eclipse.buildship.core.internal.configuration.RunConfiguration;
import org.eclipse.buildship.core.internal.gradle.GradleProgressAttributes;
import org.eclipse.buildship.core.internal.operation.BaseToolingApiOperation;
import org.eclipse.buildship.core.internal.workspace.InternalGradleBuild;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.JavaConventions;
import org.gradle.api.JavaVersion;
import org.gradle.tooling.CancellationTokenSource;

public class InitializeNewProjectOperation
extends BaseToolingApiOperation {
    private final BuildConfiguration buildConfiguration;
    private static final String CURRENT_JAVA_VERSION = JavaVersion.current().getMajorVersion();

    public InitializeNewProjectOperation(BuildConfiguration buildConfiguration) {
        super("Initialize project " + buildConfiguration.getRootProjectDirectory().getName());
        this.buildConfiguration = buildConfiguration;
    }

    @Override
    public void runInToolingApi(CancellationTokenSource tokenSource, IProgressMonitor monitor) throws Exception {
        InitializeNewProjectOperation.initProjectIfNotExists(this.buildConfiguration, tokenSource, monitor);
    }

    private static void initProjectIfNotExists(BuildConfiguration buildConfig, CancellationTokenSource tokenSource, IProgressMonitor monitor) {
        File projectDir = buildConfig.getRootProjectDirectory().getAbsoluteFile();
        if (!projectDir.exists() && projectDir.mkdir()) {
            InternalGradleBuild gradleBuild = CorePlugin.internalGradleWorkspace().getGradleBuild(buildConfig);
            RunConfiguration runConfiguration = CorePlugin.configurationManager().createDefaultRunConfiguration(buildConfig);
            GradleProgressAttributes progressAttributes = GradleProgressAttributes.builder(tokenSource, gradleBuild, monitor).forNonInteractiveBackgroundProcess().withFilteredProgress().build();
            gradleBuild.newBuildLauncher(runConfiguration, progressAttributes).forTasks(InitializeNewProjectOperation.createInitJavaLibraryTask(runConfiguration.getProjectConfiguration())).run();
        }
    }

    private static String[] createInitJavaLibraryTask(ProjectConfiguration projectConfiguration) {
        String escapedPackageName = Arrays.stream(projectConfiguration.getProjectDir().getName().split("\\.")).filter(segment -> !Strings.isNullOrEmpty((String)segment)).map(InitializeNewProjectOperation::escapePackageNameSegment).collect(Collectors.joining("."));
        return new String[]{"init", "--type", "java-library", "--package", escapedPackageName};
    }

    private static String escapePackageNameSegment(String packageNameSegment) {
        IStatus status = JavaConventions.validatePackageName((String)packageNameSegment, (String)CURRENT_JAVA_VERSION, (String)CURRENT_JAVA_VERSION);
        if (status.getCode() == 0) {
            return packageNameSegment;
        }
        return "_" + packageNameSegment;
    }

    @Override
    public ISchedulingRule getRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }
}

