/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.workspace;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.buildship.core.GradleBuild;
import org.eclipse.buildship.core.GradleCore;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.configuration.GradleProjectNature;
import org.eclipse.buildship.core.internal.configuration.ProjectConfiguration;
import org.eclipse.buildship.core.internal.operation.ToolingApiJobResultHandler;
import org.eclipse.buildship.core.internal.operation.ToolingApiStatus;
import org.eclipse.buildship.core.internal.preferences.PersistentModel;
import org.eclipse.buildship.core.internal.workspace.SynchronizationJob;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public final class SynchronizingBuildScriptUpdateListener
implements IResourceChangeListener {
    private SynchronizingBuildScriptUpdateListener() {
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta delta = event.getDelta();
        if (delta != null) {
            try {
                this.visitDelta(delta);
            }
            catch (CoreException e) {
                CorePlugin.logger().warn("Failed to detect project changes", e);
            }
        }
    }

    private boolean isEnabledInPreferences(IProject project) {
        ProjectConfiguration configuration = CorePlugin.configurationManager().loadProjectConfiguration(project);
        return configuration.getBuildConfiguration().isAutoSync();
    }

    private void visitDelta(IResourceDelta delta) throws CoreException {
        delta.accept(new IResourceDeltaVisitor(){

            public boolean visit(IResourceDelta delta) throws CoreException {
                try {
                    return SynchronizingBuildScriptUpdateListener.this.doVisitDelta(delta);
                }
                catch (Exception e) {
                    throw new CoreException((IStatus)new Status(2, "org.eclipse.buildship.core", "SynchronizingBuildScriptUpdateListener failed", (Throwable)e));
                }
            }
        });
    }

    private boolean doVisitDelta(IResourceDelta delta) throws Exception {
        IResource resource = delta.getResource();
        if (resource instanceof IProject) {
            IProject project = (IProject)resource;
            if (GradleProjectNature.isPresentOn(project) && this.isEnabledInPreferences(project)) {
                this.executeSyncIfBuildScriptChanged(project, delta);
            }
            return false;
        }
        return resource instanceof IWorkspaceRoot;
    }

    private void executeSyncIfBuildScriptChanged(IProject project, IResourceDelta delta) {
        if (this.hasBuildScriptFileChanged(project, delta.getAffectedChildren())) {
            GradleBuild gradleBuild = GradleCore.getWorkspace().getBuild(project).get();
            SynchronizationJob job = new SynchronizationJob(gradleBuild);
            job.setResultHandler(new ResultHander());
            job.schedule();
        }
    }

    private boolean hasBuildScriptFileChanged(IProject project, IResourceDelta[] deltas) {
        PersistentModel model = CorePlugin.modelPersistence().loadModel(project);
        if (!model.isPresent()) {
            return false;
        }
        IPath buildScriptPath = model.getbuildScriptPath();
        Set<IPath> affectedResourcePaths = this.collectAffectedResourcePaths(deltas);
        return affectedResourcePaths.contains(buildScriptPath);
    }

    private Set<IPath> collectAffectedResourcePaths(IResourceDelta[] children) {
        HashSet result = Sets.newHashSet();
        this.collectAffectedResourcePaths(result, children);
        return result;
    }

    private void collectAffectedResourcePaths(Set<IPath> result, IResourceDelta[] deltas) {
        for (IResourceDelta delta : deltas) {
            result.add(delta.getResource().getProjectRelativePath());
            this.collectAffectedResourcePaths(result, delta.getAffectedChildren());
        }
    }

    public static SynchronizingBuildScriptUpdateListener createAndRegister() {
        SynchronizingBuildScriptUpdateListener listener = new SynchronizingBuildScriptUpdateListener();
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)listener, 1);
        return listener;
    }

    public void close() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
    }

    private static final class ResultHander
    implements ToolingApiJobResultHandler<Void> {
        private ResultHander() {
        }

        @Override
        public void onSuccess(Void result) {
        }

        @Override
        public void onFailure(ToolingApiStatus status) {
            CorePlugin.getInstance().getLog().log((IStatus)status);
        }
    }
}

