/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.gradleware.tooling.toolingmodel.repository.TransientRequestAttributes;
import java.io.Writer;
import org.eclipse.buildship.core.configuration.BuildConfiguration;
import org.eclipse.buildship.core.configuration.RunConfiguration;
import org.eclipse.buildship.core.util.progress.AsyncHandler;
import org.eclipse.buildship.core.workspace.GradleBuild;
import org.eclipse.buildship.core.workspace.ModelProvider;
import org.eclipse.buildship.core.workspace.NewProjectHandler;
import org.eclipse.buildship.core.workspace.internal.ConnectionAwareLauncherProxy;
import org.eclipse.buildship.core.workspace.internal.DefaultModelProvider;
import org.eclipse.buildship.core.workspace.internal.SynchronizeGradleBuildsJob;
import org.eclipse.core.runtime.jobs.Job;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.TestLauncher;

public class DefaultGradleBuild
implements GradleBuild {
    private final BuildConfiguration buildConfig;
    private final DefaultModelProvider modelProvider;

    public DefaultGradleBuild(BuildConfiguration buildConfig) {
        this.buildConfig = (BuildConfiguration)Preconditions.checkNotNull((Object)buildConfig);
        this.modelProvider = new DefaultModelProvider(this.buildConfig);
    }

    @Override
    public void synchronize() {
        this.synchronize(NewProjectHandler.NO_OP);
    }

    @Override
    public void synchronize(NewProjectHandler newProjectHandler) {
        this.synchronize(newProjectHandler, AsyncHandler.NO_OP);
    }

    @Override
    public void synchronize(NewProjectHandler newProjectHandler, AsyncHandler initializer) {
        SynchronizeGradleBuildsJob.forSingleGradleBuild(this, newProjectHandler, initializer).schedule();
    }

    @Override
    public boolean isSyncRunning() {
        Job[] syncJobs;
        for (Job job : syncJobs = Job.getJobManager().find((Object)"org.eclipse.buildship.core.jobs")) {
            if (!(job instanceof SynchronizeGradleBuildsJob)) continue;
            for (GradleBuild gradleBuild : ((SynchronizeGradleBuildsJob)job).getBuilds()) {
                if (!gradleBuild.getBuildConfig().getRootProjectDirectory().equals(this.buildConfig.getRootProjectDirectory())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public ModelProvider getModelProvider() {
        return this.modelProvider;
    }

    @Override
    public BuildConfiguration getBuildConfig() {
        return this.buildConfig;
    }

    @Override
    public BuildLauncher newBuildLauncher(RunConfiguration runConfiguration, Writer configWriter, TransientRequestAttributes transientAttributes) {
        return ConnectionAwareLauncherProxy.newBuildLauncher(runConfiguration.toGradleArguments(), configWriter, transientAttributes);
    }

    @Override
    public TestLauncher newTestLauncher(RunConfiguration runConfiguration, Writer configWriter, TransientRequestAttributes transientAttributes) {
        return ConnectionAwareLauncherProxy.newTestLauncher(runConfiguration.toGradleArguments(), configWriter, transientAttributes);
    }

    public boolean equals(Object obj) {
        if (obj instanceof DefaultGradleBuild) {
            DefaultGradleBuild other = (DefaultGradleBuild)obj;
            return Objects.equal((Object)this.buildConfig, (Object)other.buildConfig);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.buildConfig});
    }
}

