/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.launch;

import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.gradleware.tooling.toolingclient.GradleDistribution;
import com.gradleware.tooling.toolingutils.binding.Validator;
import java.io.File;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.configuration.GradleProjectNature;
import org.eclipse.buildship.core.i18n.CoreMessages;
import org.eclipse.buildship.core.launch.GradleRunConfigurationAttributes;
import org.eclipse.buildship.core.util.binding.Validators;
import org.eclipse.buildship.core.util.gradle.GradleDistributionValidator;
import org.eclipse.buildship.core.util.gradle.GradleDistributionWrapper;
import org.eclipse.buildship.ui.PluginImage;
import org.eclipse.buildship.ui.PluginImages;
import org.eclipse.buildship.ui.launch.LaunchMessages;
import org.eclipse.buildship.ui.util.widget.GradleDistributionGroup;
import org.eclipse.buildship.ui.util.widget.GradleProjectSettingsComposite;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PreferencesUtil;

public final class ProjectSettingsTab
extends AbstractLaunchConfigurationTab {
    private final Validator<GradleDistributionWrapper> gradleDistributionValidator = GradleDistributionValidator.gradleDistributionValidator();
    private final Validator<File> gradleUserHomeValidator = Validators.optionalDirectoryValidator((String)"Gradle user home");
    private GradleRunConfigurationAttributes attributes;
    private GradleProjectSettingsComposite gradleProjectSettingsComposite;

    public String getName() {
        return LaunchMessages.Tab_Name_ProjectSettings;
    }

    public Image getImage() {
        return PluginImages.RUN_CONFIG_GRADLE_DISTRIBUTION.withState(PluginImage.ImageState.ENABLED).getImage();
    }

    public void createControl(Composite parent) {
        this.gradleProjectSettingsComposite = GradleProjectSettingsComposite.withOverrideCheckbox(parent, CoreMessages.RunConfiguration_Label_OverrideProjectSettings, "Configure Project Settings");
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)this.gradleProjectSettingsComposite);
        this.setControl((Control)this.gradleProjectSettingsComposite);
        this.addListeners();
    }

    private void addListeners() {
        DialogUpdater dialogUpdater = new DialogUpdater();
        this.gradleProjectSettingsComposite.getOverrideBuildSettingsCheckbox().addSelectionListener((SelectionListener)dialogUpdater);
        this.gradleProjectSettingsComposite.getOfflineModeCheckbox().addSelectionListener((SelectionListener)dialogUpdater);
        this.gradleProjectSettingsComposite.getBuildScansCheckbox().addSelectionListener((SelectionListener)dialogUpdater);
        this.gradleProjectSettingsComposite.getGradleDistributionGroup().addDistributionChangedListener(dialogUpdater);
        this.gradleProjectSettingsComposite.getGradleUserHomeGroup().getGradleUserHomeText().addModifyListener((ModifyListener)dialogUpdater);
        this.gradleProjectSettingsComposite.getParentPreferenceLink().addSelectionListener((SelectionListener)new ProjectPreferenceOpeningSelectionListener());
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.attributes = GradleRunConfigurationAttributes.from((ILaunchConfiguration)configuration);
        this.gradleProjectSettingsComposite.getOverrideBuildSettingsCheckbox().setSelection(this.attributes.isOverrideBuildSettings());
        this.gradleProjectSettingsComposite.getGradleDistributionGroup().setGradleDistribution(GradleDistributionWrapper.from((GradleDistribution)this.attributes.getGradleDistribution()));
        this.gradleProjectSettingsComposite.getGradleUserHomeGroup().getGradleUserHomeText().setText(Strings.nullToEmpty((String)this.attributes.getGradleUserHomeHomeExpression()));
        this.gradleProjectSettingsComposite.getOfflineModeCheckbox().setSelection(this.attributes.isOffline());
        this.gradleProjectSettingsComposite.getBuildScansCheckbox().setSelection(this.attributes.isBuildScansEnabled());
        this.gradleProjectSettingsComposite.updateEnablement();
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        GradleRunConfigurationAttributes.applyOverrideBuildSettings((boolean)this.gradleProjectSettingsComposite.getOverrideBuildSettingsCheckbox().getSelection(), (ILaunchConfigurationWorkingCopy)configuration);
        GradleRunConfigurationAttributes.applyGradleDistribution((GradleDistribution)this.gradleProjectSettingsComposite.getGradleDistributionGroup().getGradleDistribution().toGradleDistribution(), (ILaunchConfigurationWorkingCopy)configuration);
        GradleRunConfigurationAttributes.applyGradleUserHomeExpression((String)this.gradleProjectSettingsComposite.getGradleUserHomeGroup().getGradleUserHomeText().getText(), (ILaunchConfigurationWorkingCopy)configuration);
        GradleRunConfigurationAttributes.applyOfflineMode((boolean)this.gradleProjectSettingsComposite.getOfflineModeCheckbox().getSelection(), (ILaunchConfigurationWorkingCopy)configuration);
        GradleRunConfigurationAttributes.applyBuildScansEnabled((boolean)this.gradleProjectSettingsComposite.getBuildScansCheckbox().getSelection(), (ILaunchConfigurationWorkingCopy)configuration);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        GradleDistributionWrapper gradleDistribution = this.gradleProjectSettingsComposite.getGradleDistributionGroup().getGradleDistribution();
        Optional error = this.gradleDistributionValidator.validate((Object)gradleDistribution);
        if (!error.isPresent()) {
            error = this.gradleUserHomeValidator.validate((Object)this.gradleProjectSettingsComposite.getGradleUserHomeGroup().getGradleUserHome());
        }
        this.setErrorMessage((String)error.orNull());
        return !error.isPresent();
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    private class DialogUpdater
    extends SelectionAdapter
    implements ModifyListener,
    GradleDistributionGroup.DistributionChangedListener {
        private DialogUpdater() {
        }

        public void widgetSelected(SelectionEvent e) {
            ProjectSettingsTab.this.updateLaunchConfigurationDialog();
        }

        public void modifyText(ModifyEvent e) {
            ProjectSettingsTab.this.updateLaunchConfigurationDialog();
        }

        @Override
        public void distributionUpdated(GradleDistributionWrapper distribution) {
            ProjectSettingsTab.this.updateLaunchConfigurationDialog();
        }
    }

    private class ProjectPreferenceOpeningSelectionListener
    implements SelectionListener {
        private ProjectPreferenceOpeningSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            this.openWorkspacePreferences();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.openWorkspacePreferences();
        }

        private void openWorkspacePreferences() {
            try {
                File workingDir = ProjectSettingsTab.this.attributes.getWorkingDir();
                Optional project = CorePlugin.workspaceOperations().findProjectByLocation(workingDir);
                if (project.isPresent() && GradleProjectNature.isPresentOn((IProject)((IProject)project.get()))) {
                    PreferencesUtil.createPropertyDialogOn((Shell)ProjectSettingsTab.this.getShell(), (IAdaptable)((IAdaptable)project.get()), (String)"org.eclipse.buildship.ui.projectproperties", null, null).open();
                }
            }
            catch (Exception e) {
                CorePlugin.logger().debug("Cannot open project preferences", (Throwable)e);
            }
        }
    }
}

