/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.workspace;

import com.google.common.collect.Sets;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import java.io.File;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.configuration.GradleProjectNature;
import org.eclipse.buildship.core.util.collections.AdapterFunction;
import org.eclipse.buildship.core.util.configuration.FixedRequestAttributesBuilder;
import org.eclipse.buildship.core.workspace.GradleBuild;
import org.eclipse.buildship.core.workspace.NewProjectHandler;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class AddBuildshipNatureHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof StructuredSelection) {
            List elements = ((StructuredSelection)selection).toList();
            Set<FixedRequestAttributes> builds = this.collectGradleBuilds(elements);
            this.synchronize(builds);
        }
        return null;
    }

    private Set<FixedRequestAttributes> collectGradleBuilds(List<?> elements) {
        LinkedHashSet builds = Sets.newLinkedHashSet();
        AdapterFunction adapterFunction = AdapterFunction.forType(IProject.class);
        for (Object element : elements) {
            IPath location;
            IProject project = (IProject)adapterFunction.apply(element);
            if (project == null || GradleProjectNature.isPresentOn((IProject)project) || (location = project.getLocation()) == null) continue;
            builds.add(FixedRequestAttributesBuilder.fromWorkspaceSettings((File)location.toFile()).build());
        }
        return builds;
    }

    private void synchronize(Set<FixedRequestAttributes> builds) {
        for (FixedRequestAttributes build : builds) {
            GradleBuild gradleBuild = CorePlugin.gradleWorkspaceManager().getGradleBuild(build);
            gradleBuild.synchronize(NewProjectHandler.IMPORT_AND_MERGE);
        }
    }
}

