/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.navigator;

import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.preferences.PersistentModel;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public final class BuildFolderViewerFilter
extends ViewerFilter {
    public boolean select(Viewer viewer, Object parentElement, Object element) {
        IResource resource = (IResource)Platform.getAdapterManager().getAdapter(element, IResource.class);
        return resource == null || !this.isBuildFolder(resource);
    }

    private boolean isBuildFolder(IResource resource) {
        if (resource instanceof IFolder) {
            return BuildFolderViewerFilter.isBuildFolderInPerstentModel((IFolder)resource);
        }
        return false;
    }

    public static boolean isBuildFolderInPerstentModel(IFolder folder) {
        try {
            IProject project = folder.getProject();
            PersistentModel model = CorePlugin.modelPersistence().loadModel(project);
            if (!model.isPresent()) {
                return false;
            }
            IPath modelBuildDir = model.getBuildDir();
            return modelBuildDir == null ? false : folder.getProjectRelativePath().equals((Object)modelBuildDir);
        }
        catch (Exception e) {
            CorePlugin.logger().debug(String.format("Could not check whether folder %s is a build folder.", folder.getFullPath()), (Throwable)e);
            return false;
        }
    }
}

