/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.configuration.internal;

import com.google.common.base.Charsets;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Properties;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

abstract class PreferenceStore {
    private PreferenceStore() {
    }

    abstract String read(String var1);

    abstract void write(String var1, String var2);

    void delete(String key) {
        this.write(key, null);
    }

    abstract void flush();

    static PreferenceStore forProjectScope(IProject project, String node) {
        return new ProjectScopeEclipsePreferencesPreferenceStore(project, node);
    }

    static PreferenceStore forPreferenceFile(File propertiesFile) {
        return new PropertiesFilePreferenceStore(propertiesFile);
    }

    private static final class ProjectScopeEclipsePreferencesPreferenceStore
    extends PreferenceStore {
        private final IProject project;
        private final String node;
        private final IEclipsePreferences preferences;

        private ProjectScopeEclipsePreferencesPreferenceStore(IProject project, String node) {
            this.project = project;
            this.node = node;
            this.preferences = new ProjectScope(project).getNode(node);
        }

        @Override
        String read(String key) {
            return this.preferences.get(key, null);
        }

        @Override
        void write(String key, String value) {
            if (value == null) {
                this.preferences.remove(key);
            } else {
                this.preferences.put(key, value);
            }
        }

        @Override
        void flush() {
            try {
                this.preferences.flush();
            }
            catch (Exception e) {
                throw new GradlePluginsRuntimeException(String.format("Cannot store preferences in project %s in node %s.", this.project.getName(), this.node), e);
            }
        }
    }

    private static final class PropertiesFilePreferenceStore
    extends PreferenceStore {
        private final File propertiesFile;
        private Properties properties;

        private PropertiesFilePreferenceStore(File propertiesFile) {
            this.propertiesFile = propertiesFile;
        }

        private Properties getProperties() {
            if (this.properties == null) {
                this.loadProperties();
            }
            return this.properties;
        }

        private void loadProperties() {
            InputStreamReader reader = null;
            try {
                reader = new InputStreamReader((InputStream)new FileInputStream(this.propertiesFile), Charsets.UTF_8);
                this.properties = new Properties();
                this.properties.load(reader);
            }
            catch (IOException e) {
                throw new GradlePluginsRuntimeException(String.format("Cannot read preference from file %s", this.propertiesFile.getAbsolutePath()), e);
            }
            finally {
                try {
                    if (reader != null) {
                        reader.close();
                    }
                }
                catch (IOException e) {}
            }
        }

        @Override
        String read(String key) {
            return this.getProperties().getProperty(key, null);
        }

        @Override
        void write(String key, String value) {
            if (value == null) {
                this.getProperties().remove(value);
            } else {
                this.getProperties().put(key, value);
            }
        }

        @Override
        void flush() {
            OutputStreamWriter writer = null;
            try {
                writer = new OutputStreamWriter((OutputStream)new FileOutputStream(this.propertiesFile), Charsets.UTF_8);
                this.getProperties().store(writer, null);
            }
            catch (IOException e) {
                throw new GradlePluginsRuntimeException(String.format("Cannot store preferences in file %s", this.propertiesFile.getAbsolutePath()), e);
            }
            finally {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException e) {}
            }
        }
    }
}

