/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Optional;
import com.gradleware.tooling.toolingmodel.OmniEclipseBuildCommand;
import java.util.List;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;

final class BuildCommandUpdater {
    BuildCommandUpdater() {
    }

    public static void update(IProject project, Optional<List<OmniEclipseBuildCommand>> buildCommands, IProgressMonitor monitor) throws CoreException {
        if (buildCommands.isPresent()) {
            BuildCommandUpdater.update(project, (List)buildCommands.get(), monitor);
        }
    }

    private static void update(IProject project, List<OmniEclipseBuildCommand> buildCommands, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = project.getDescription();
        description.setBuildSpec(BuildCommandUpdater.toCommands(buildCommands, description));
        project.setDescription(description, monitor);
    }

    private static ICommand[] toCommands(List<OmniEclipseBuildCommand> buildCommands, IProjectDescription description) {
        ICommand[] commands = new ICommand[buildCommands.size()];
        for (int i = 0; i < buildCommands.size(); ++i) {
            OmniEclipseBuildCommand buildCommand = buildCommands.get(i);
            commands[i] = BuildCommandUpdater.toCommand(buildCommand, description);
        }
        return commands;
    }

    private static ICommand toCommand(OmniEclipseBuildCommand buildCommand, IProjectDescription description) {
        ICommand command = description.newCommand();
        command.setBuilderName(buildCommand.getName());
        command.setArguments(buildCommand.getArguments());
        return command;
    }
}

