/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.launch;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;

public final class JavaElementNameCollector {
    private JavaElementNameCollector() {
    }

    public static Iterable<String> collectClassNames(List<IType> types) {
        return FluentIterable.from(types).transform((Function)new Function<IType, String>(){

            public String apply(IType type) {
                return type.getFullyQualifiedName();
            }
        }).toSet();
    }

    public static Map<String, Iterable<String>> collectClassNamesWithMethods(List<IMethod> methods) {
        HashMap testMethods = Maps.newHashMap();
        for (IMethod method : methods) {
            String typeName = method.getDeclaringType().getFullyQualifiedName();
            String methodName = method.getElementName();
            JavaElementNameCollector.createNewOrAppendToExistingEntry(testMethods, typeName, methodName);
        }
        return ImmutableMap.copyOf((Map)testMethods);
    }

    private static void createNewOrAppendToExistingEntry(Map<String, Collection<String>> collection, String key, String valueEntry) {
        ArrayList value = collection.get(key);
        if (value == null) {
            value = Lists.newArrayList();
            collection.put(key, value);
        }
        value.add(valueEntry);
    }
}

