/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.launch;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingclient.Request;
import com.gradleware.tooling.toolingclient.TestConfig;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.util.Date;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.console.ProcessDescription;
import org.eclipse.buildship.core.i18n.CoreMessages;
import org.eclipse.buildship.core.launch.BaseLaunchRequestJob;
import org.eclipse.buildship.core.launch.GradleRunConfigurationAttributes;

public final class RunGradleJvmTestLaunchRequestJob
extends BaseLaunchRequestJob {
    private final GradleRunConfigurationAttributes configurationAttributes;
    private ImmutableList<String> testClasses;

    public RunGradleJvmTestLaunchRequestJob(Iterable<String> testClasses, GradleRunConfigurationAttributes configurationAttributes) {
        super("Launching Gradle Tests", false);
        this.testClasses = ImmutableList.copyOf(testClasses);
        this.configurationAttributes = (GradleRunConfigurationAttributes)Preconditions.checkNotNull((Object)configurationAttributes);
    }

    @Override
    protected String getJobTaskName() {
        return "Launch Gradle Tests";
    }

    @Override
    protected GradleRunConfigurationAttributes getConfigurationAttributes() {
        return this.configurationAttributes;
    }

    @Override
    protected ProcessDescription createProcessDescription() {
        String processName = this.createProcessName(this.configurationAttributes.getWorkingDir());
        return new TestLaunchProcessDescription(processName);
    }

    private String createProcessName(File workingDir) {
        return String.format("[Gradle Project] %s in %s (%s)", Joiner.on((char)' ').join(this.testClasses), workingDir.getAbsolutePath(), DateFormat.getDateTimeInstance(2, 2).format(new Date()));
    }

    @Override
    protected Request<Void> createRequest() {
        return CorePlugin.toolingClient().newTestLaunchRequest(TestConfig.forJvmTestClasses(this.testClasses));
    }

    @Override
    protected void writeExtraConfigInfo(OutputStreamWriter writer) throws IOException {
        writer.write(String.format("%s: %s%n", CoreMessages.RunConfiguration_Label_Tests, this.testClasses));
    }

    private final class TestLaunchProcessDescription
    extends BaseLaunchRequestJob.BaseProcessDescription {
        public TestLaunchProcessDescription(String processName) {
            super(processName, RunGradleJvmTestLaunchRequestJob.this, RunGradleJvmTestLaunchRequestJob.this.configurationAttributes);
        }

        @Override
        public boolean isRerunnable() {
            return true;
        }

        @Override
        public void rerun() {
            RunGradleJvmTestLaunchRequestJob job = new RunGradleJvmTestLaunchRequestJob((Iterable<String>)RunGradleJvmTestLaunchRequestJob.this.testClasses, RunGradleJvmTestLaunchRequestJob.this.configurationAttributes);
            job.schedule();
        }
    }
}

