/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.notification;

import org.eclipse.buildship.core.notification.UserNotification;
import org.eclipse.buildship.ui.notification.ExceptionDetailsDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public final class DialogUserNotification
implements UserNotification {
    private ExceptionDetailsDialog dialog;

    public void errorOccurred(final String headline, final String message, final String details, final int severity, final Throwable throwable) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                if (shell == null) {
                    return;
                }
                if (DialogUserNotification.this.noDialogVisible()) {
                    DialogUserNotification.this.createAndOpenDialog(shell, headline, message, details, severity, throwable);
                } else {
                    DialogUserNotification.this.addExceptionToDialog(throwable);
                }
            }
        });
    }

    private boolean noDialogVisible() {
        return this.dialog == null || this.dialog.getShell() == null || this.dialog.getShell().isDisposed();
    }

    private void createAndOpenDialog(Shell shell, String title, String message, String details, int severity, Throwable throwable) {
        this.dialog = new ExceptionDetailsDialog(shell, title, message, details, severity, throwable);
        this.dialog.setBlockOnOpen(false);
        this.dialog.open();
    }

    private void addExceptionToDialog(Throwable throwable) {
        this.dialog.addException(throwable);
    }
}

