/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingclient.internal;

import com.google.common.base.Preconditions;
import com.gradleware.tooling.toolingclient.GradleDistribution;
import com.gradleware.tooling.toolingclient.internal.BaseRequest;
import com.gradleware.tooling.toolingclient.internal.ExecutableToolingClient;
import com.gradleware.tooling.toolingclient.internal.InspectableSingleBuildRequest;
import java.io.File;

abstract class BaseSingleBuildRequest<T, SELF extends BaseSingleBuildRequest<T, SELF>>
extends BaseRequest<T, SELF>
implements InspectableSingleBuildRequest<T> {
    private File projectDir;
    private File gradleUserHomeDir;
    private GradleDistribution gradleDistribution = GradleDistribution.fromBuild();

    BaseSingleBuildRequest(ExecutableToolingClient toolingClient) {
        super(toolingClient);
    }

    public SELF projectDir(File projectDir) {
        this.projectDir = projectDir;
        return (SELF)((BaseSingleBuildRequest)this.getThis());
    }

    @Override
    public File getProjectDir() {
        return this.projectDir;
    }

    public SELF gradleUserHomeDir(File gradleUserHomeDir) {
        this.gradleUserHomeDir = gradleUserHomeDir;
        return (SELF)((BaseSingleBuildRequest)this.getThis());
    }

    @Override
    public File getGradleUserHomeDir() {
        return this.gradleUserHomeDir;
    }

    public SELF gradleDistribution(GradleDistribution gradleDistribution) {
        this.gradleDistribution = (GradleDistribution)Preconditions.checkNotNull((Object)gradleDistribution);
        return (SELF)((BaseSingleBuildRequest)this.getThis());
    }

    @Override
    public GradleDistribution getGradleDistribution() {
        return this.gradleDistribution;
    }

    @Override
    <S, S_SELF extends BaseRequest<S, S_SELF>> S_SELF copy(BaseRequest<S, S_SELF> request) {
        S_SELF copy = super.copy(request);
        if (copy instanceof BaseSingleBuildRequest) {
            BaseSingleBuildRequest simpleRequest = (BaseSingleBuildRequest)request;
            ((BaseSingleBuildRequest)((BaseSingleBuildRequest)simpleRequest.projectDir(this.getProjectDir())).gradleUserHomeDir(this.getGradleUserHomeDir())).gradleDistribution(this.getGradleDistribution());
        }
        return copy;
    }
}

