/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui;

import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.Logger;
import org.eclipse.buildship.core.console.ProcessStreamsProvider;
import org.eclipse.buildship.core.event.EventListener;
import org.eclipse.buildship.core.notification.UserNotification;
import org.eclipse.buildship.core.util.logging.EclipseLogger;
import org.eclipse.buildship.ui.PluginImages;
import org.eclipse.buildship.ui.console.ConsoleProcessStreamsProvider;
import org.eclipse.buildship.ui.launch.ConsoleShowingLaunchListener;
import org.eclipse.buildship.ui.notification.DialogUserNotification;
import org.eclipse.buildship.ui.util.predicate.Predicates;
import org.eclipse.buildship.ui.util.selection.ContextActivatingSelectionListener;
import org.eclipse.buildship.ui.util.selection.ContextActivatingWindowListener;
import org.eclipse.buildship.ui.view.execution.ExecutionShowingBuildLaunchRequestListener;
import org.eclipse.buildship.ui.wizard.project.WorkingSetsAddingProjectCreatedListener;
import org.eclipse.buildship.ui.workspace.RefreshProjectCommandExecutionListener;
import org.eclipse.core.commands.IExecutionListener;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.services.IServiceLocator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public final class UiPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.buildship.ui";
    private static UiPlugin plugin;
    private ServiceRegistration loggerService;
    private ServiceRegistration processStreamsProviderService;
    private ServiceRegistration dialogUserNotificationService;
    private ConsoleShowingLaunchListener consoleShowingLaunchListener;
    private ExecutionShowingBuildLaunchRequestListener executionShowingBuildLaunchRequestListener;
    private WorkingSetsAddingProjectCreatedListener workingSetsAddingProjectCreatedListener;
    private ContextActivatingSelectionListener contextActivatingSelectionListener;
    private ContextActivatingWindowListener contextActivatingWindowListener;
    private RefreshProjectCommandExecutionListener refreshCommandExecutionListener;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        this.registerServices(context);
        this.registerListeners();
    }

    public void stop(BundleContext context) throws Exception {
        this.unregisterListeners();
        this.unregisterServices();
        plugin = null;
        super.stop(context);
    }

    private void registerServices(BundleContext context) {
        Hashtable<String, Object> preferences = new Hashtable<String, Object>();
        ((Dictionary)preferences).put("service.ranking", 1);
        Hashtable<String, Object> priorityPreferences = new Hashtable<String, Object>();
        ((Dictionary)priorityPreferences).put("service.ranking", 2);
        this.loggerService = this.registerService(context, Logger.class, this.createLogger(), preferences);
        this.processStreamsProviderService = this.registerService(context, ProcessStreamsProvider.class, this.createConsoleProcessStreamsProvider(), priorityPreferences);
        this.dialogUserNotificationService = this.registerService(context, UserNotification.class, this.createUserNotification(), priorityPreferences);
    }

    private <T> ServiceRegistration registerService(BundleContext context, Class<T> clazz, T service, Dictionary<String, Object> properties) {
        return context.registerService(clazz.getName(), service, properties);
    }

    private EclipseLogger createLogger() {
        return new EclipseLogger(this.getLog(), PLUGIN_ID, this.isDebugging());
    }

    private ProcessStreamsProvider createConsoleProcessStreamsProvider() {
        return new ConsoleProcessStreamsProvider();
    }

    private UserNotification createUserNotification() {
        return new DialogUserNotification();
    }

    private void unregisterServices() {
        this.dialogUserNotificationService.unregister();
        this.processStreamsProviderService.unregister();
        this.loggerService.unregister();
    }

    private void registerListeners() {
        IWorkbenchWindow[] workbenchWindows;
        this.consoleShowingLaunchListener = new ConsoleShowingLaunchListener();
        this.consoleShowingLaunchListener.handleAlreadyRunningLaunches();
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchListener)this.consoleShowingLaunchListener);
        this.executionShowingBuildLaunchRequestListener = new ExecutionShowingBuildLaunchRequestListener();
        CorePlugin.listenerRegistry().addEventListener((EventListener)this.executionShowingBuildLaunchRequestListener);
        this.workingSetsAddingProjectCreatedListener = new WorkingSetsAddingProjectCreatedListener();
        CorePlugin.listenerRegistry().addEventListener((EventListener)this.workingSetsAddingProjectCreatedListener);
        this.contextActivatingSelectionListener = new ContextActivatingSelectionListener("org.eclipse.buildship.ui.contexts.gradlenature", Predicates.hasGradleNature(), (IServiceLocator)this.getWorkbench());
        for (IWorkbenchWindow workbenchWindow : workbenchWindows = this.getWorkbench().getWorkbenchWindows()) {
            ISelectionService selectionService = workbenchWindow.getSelectionService();
            if (selectionService == null) continue;
            selectionService.addSelectionListener((ISelectionListener)this.contextActivatingSelectionListener);
        }
        this.contextActivatingWindowListener = new ContextActivatingWindowListener(this.contextActivatingSelectionListener);
        this.getWorkbench().addWindowListener((IWindowListener)this.contextActivatingWindowListener);
        this.refreshCommandExecutionListener = new RefreshProjectCommandExecutionListener();
        ICommandService commandService = (ICommandService)this.getWorkbench().getService(ICommandService.class);
        commandService.addExecutionListener((IExecutionListener)this.refreshCommandExecutionListener);
    }

    private void unregisterListeners() {
        IWorkbenchWindow[] workbenchWindows;
        ICommandService commandService = (ICommandService)this.getWorkbench().getService(ICommandService.class);
        if (commandService != null) {
            commandService.removeExecutionListener((IExecutionListener)this.refreshCommandExecutionListener);
        }
        this.getWorkbench().removeWindowListener((IWindowListener)this.contextActivatingWindowListener);
        for (IWorkbenchWindow workbenchWindow : workbenchWindows = this.getWorkbench().getWorkbenchWindows()) {
            ISelectionService selectionService = workbenchWindow.getSelectionService();
            if (selectionService == null) continue;
            selectionService.removeSelectionListener((ISelectionListener)this.contextActivatingSelectionListener);
        }
        CorePlugin.listenerRegistry().removeEventListener((EventListener)this.workingSetsAddingProjectCreatedListener);
        CorePlugin.listenerRegistry().removeEventListener((EventListener)this.executionShowingBuildLaunchRequestListener);
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchListener)this.consoleShowingLaunchListener);
    }

    public static UiPlugin getInstance() {
        return plugin;
    }

    public static Logger logger() {
        return (Logger)UiPlugin.getService(UiPlugin.getInstance().loggerService.getReference());
    }

    private static <T> T getService(ServiceReference reference) {
        return (T)reference.getBundle().getBundleContext().getService(reference);
    }

    protected void initializeImageRegistry(ImageRegistry imageRegistry) {
        for (PluginImages pluginImage : PluginImages.values()) {
            pluginImage.register();
        }
    }
}

