/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import org.eclipse.buildship.core.AggregateException;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.util.predicate.Predicates;
import org.eclipse.buildship.core.util.progress.ToolingApiCommand;
import org.eclipse.buildship.core.util.progress.ToolingApiInvoker;
import org.eclipse.buildship.core.workspace.RefreshGradleProjectJob;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;

public final class RefreshGradleProjectsJob
extends Job {
    private final List<IProject> projects;

    public RefreshGradleProjectsJob(List<IProject> projects) {
        super("Refresh Gradle projects");
        this.projects = ImmutableList.copyOf(projects);
    }

    protected IStatus run(final IProgressMonitor monitor) {
        ToolingApiInvoker invoker = new ToolingApiInvoker(this.getName(), true);
        return invoker.invoke(new ToolingApiCommand(){

            @Override
            public void run() throws Throwable {
                RefreshGradleProjectsJob.this.scheduleRefreshJobs(monitor);
            }
        }, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void scheduleRefreshJobs(final IProgressMonitor monitor) throws Throwable {
        Set<FixedRequestAttributes> rootRequestAttributes = this.getUniqueRootAttributes(this.projects);
        monitor.beginTask("Refresh selected Gradle projects in workspace", rootRequestAttributes.size());
        final CopyOnWriteArrayList<Throwable> errors = new CopyOnWriteArrayList<Throwable>();
        try {
            final CountDownLatch latch = new CountDownLatch(rootRequestAttributes.size());
            for (FixedRequestAttributes requestAttributes : rootRequestAttributes) {
                RefreshGradleProjectJob refreshJob = new RefreshGradleProjectJob(requestAttributes);
                refreshJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                    public void done(IJobChangeEvent event) {
                        Throwable error;
                        if (!event.getResult().isOK() && (error = event.getResult().getException()) != null) {
                            errors.add(error);
                        }
                        monitor.worked(1);
                        latch.countDown();
                    }
                });
                refreshJob.schedule();
            }
            latch.await();
        }
        finally {
            monitor.done();
            this.rethrowExceptionsIfAny(errors);
        }
    }

    private Set<FixedRequestAttributes> getUniqueRootAttributes(List<IProject> projects) {
        return FluentIterable.from(projects).filter(Predicates.accessibleGradleProject()).transform((Function)new Function<IProject, FixedRequestAttributes>(){

            public FixedRequestAttributes apply(IProject project) {
                return CorePlugin.projectConfigurationManager().readProjectConfiguration(project).getRequestAttributes();
            }
        }).toSet();
    }

    private void rethrowExceptionsIfAny(List<Throwable> errors) throws Throwable {
        if (errors.size() == 1) {
            throw errors.get(0);
        }
        if (errors.size() > 1) {
            throw new AggregateException(errors);
        }
    }

    protected void canceling() {
        Job.getJobManager().cancel((Object)RefreshGradleProjectJob.class.getName());
    }
}

