/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.gradleware.tooling.toolingmodel.OmniClasspathEntry;
import com.gradleware.tooling.toolingmodel.OmniEclipseClasspathContainer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.buildship.core.util.classpath.ClasspathUtils;
import org.eclipse.buildship.core.workspace.GradleClasspathContainer;
import org.eclipse.buildship.core.workspace.internal.StringSetProjectProperty;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.launching.JavaRuntime;

final class ClasspathContainerUpdater {
    private static final String PROJECT_PROPERTY_KEY_GRADLE_CONTAINERS = "containers";
    private final IJavaProject project;
    private final List<OmniEclipseClasspathContainer> containers;
    private final Set<String> containerPaths;
    private final boolean containersContainJre;

    private ClasspathContainerUpdater(IJavaProject project, List<OmniEclipseClasspathContainer> containers) {
        this.project = project;
        this.containers = ImmutableList.copyOf(containers);
        this.containerPaths = new HashSet<String>();
        boolean containersContainJre = false;
        String defaultJrePath = JavaRuntime.newDefaultJREContainerPath().toPortableString();
        for (OmniEclipseClasspathContainer container : this.containers) {
            String containerPath = container.getPath();
            this.containerPaths.add(containerPath);
            if (!containerPath.startsWith(defaultJrePath)) continue;
            containersContainJre = true;
        }
        this.containersContainJre = containersContainJre;
    }

    private void updateContainers(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        progress.setWorkRemaining(3);
        LinkedHashSet<IPath> toRemove = this.collectContainersToRemove(progress.newChild(1));
        LinkedHashMap<IPath, IClasspathEntry> toAdd = this.collectContainersToAdd(progress.newChild(1));
        this.updateProjectClasspath(toRemove, toAdd, progress.newChild(1));
    }

    private LinkedHashSet<IPath> collectContainersToRemove(SubMonitor progress) throws JavaModelException {
        StringSetProjectProperty previousPaths = StringSetProjectProperty.from(this.project.getProject(), PROJECT_PROPERTY_KEY_GRADLE_CONTAINERS);
        LinkedHashSet result = Sets.newLinkedHashSet();
        for (String previousPath : previousPaths.get()) {
            if (this.containerPaths.contains(previousPath)) continue;
            result.add(new Path(previousPath));
        }
        if (this.containersContainJre) {
            IPath defaultJrePath = JavaRuntime.newDefaultJREContainerPath();
            for (IClasspathEntry entry : this.project.getRawClasspath()) {
                if (entry.getEntryKind() != 5 || !defaultJrePath.isPrefixOf(entry.getPath())) continue;
                result.add(entry.getPath());
            }
        }
        return result;
    }

    private LinkedHashMap<IPath, IClasspathEntry> collectContainersToAdd(SubMonitor progress) {
        LinkedHashMap result = Maps.newLinkedHashMap();
        for (OmniEclipseClasspathContainer container : this.containers) {
            result.put(new Path(container.getPath()), ClasspathContainerUpdater.createContainerEntry(container));
        }
        if (!result.keySet().contains(GradleClasspathContainer.CONTAINER_PATH)) {
            result.put(GradleClasspathContainer.CONTAINER_PATH, JavaCore.newContainerEntry((IPath)GradleClasspathContainer.CONTAINER_PATH));
        }
        return result;
    }

    private void updateProjectClasspath(LinkedHashSet<IPath> containersToRemove, LinkedHashMap<IPath, IClasspathEntry> containersToAdd, SubMonitor progress) throws JavaModelException {
        StringSetProjectProperty containerPaths = StringSetProjectProperty.from(this.project.getProject(), PROJECT_PROPERTY_KEY_GRADLE_CONTAINERS);
        containerPaths.set(this.containerPaths);
        this.updateClasspathContainerEntries(containersToRemove, containersToAdd, progress);
    }

    private void updateClasspathContainerEntries(Set<IPath> containersToRemove, Map<IPath, IClasspathEntry> containersToAdd, SubMonitor progress) throws JavaModelException {
        ArrayList classpath = Lists.newArrayList((Object[])this.project.getRawClasspath());
        ListIterator<IClasspathEntry> iterator = classpath.listIterator();
        while (iterator.hasNext()) {
            IClasspathEntry entry = (IClasspathEntry)iterator.next();
            if (entry.getEntryKind() != 5) continue;
            IPath entryPath = entry.getPath();
            if (containersToRemove.contains(entryPath)) {
                containersToRemove.remove(entryPath);
                iterator.remove();
                continue;
            }
            if (!containersToAdd.containsKey(entryPath)) continue;
            IClasspathEntry newEntry = containersToAdd.remove(entryPath);
            iterator.set(newEntry);
        }
        classpath.addAll(containersToAdd.values());
        this.project.setRawClasspath(classpath.toArray(new IClasspathEntry[classpath.size()]), (IProgressMonitor)progress);
    }

    private static IClasspathEntry createContainerEntry(OmniEclipseClasspathContainer container) {
        Path containerPath = new Path(container.getPath());
        boolean isExported = container.isExported();
        IAccessRule[] accessRules = ClasspathUtils.createAccessRules((OmniClasspathEntry)container);
        IClasspathAttribute[] attributes = ClasspathUtils.createClasspathAttributes((OmniClasspathEntry)container);
        return JavaCore.newContainerEntry((IPath)containerPath, (IAccessRule[])accessRules, (IClasspathAttribute[])attributes, (boolean)isExported);
    }

    public static void update(IJavaProject project, Optional<List<OmniEclipseClasspathContainer>> containers, IProgressMonitor monitor) throws CoreException {
        new ClasspathContainerUpdater(project, (List)containers.or(Collections.emptyList())).updateContainers(monitor);
    }
}

