/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingclient.internal.deduplication;

import com.google.common.collect.Sets;
import com.gradleware.tooling.toolingclient.internal.deduplication.DelegatingEclipseProject;
import com.gradleware.tooling.toolingclient.internal.deduplication.RedirectedProjectLookup;
import com.gradleware.tooling.toolingclient.internal.deduplication.RedirectionAwareEclipseProjectDependency;
import java.util.HashSet;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.eclipse.EclipseProject;
import org.gradle.tooling.model.eclipse.EclipseProjectDependency;
import org.gradle.tooling.model.internal.ImmutableDomainObjectSet;

public class RedirectionAwareEclipseProject
extends DelegatingEclipseProject {
    private final RedirectedProjectLookup redirectedProjectLookup;

    public RedirectionAwareEclipseProject(EclipseProject original, RedirectedProjectLookup redirectedProjectLookup) {
        super(original);
        this.redirectedProjectLookup = redirectedProjectLookup;
    }

    @Override
    public DomainObjectSet<? extends EclipseProject> getChildren() {
        DomainObjectSet<? extends EclipseProject> children = super.getChildren();
        HashSet rendirectedChildren = Sets.newHashSet();
        for (EclipseProject child : children) {
            rendirectedChildren.add(this.redirectedProjectLookup.getRedirectedProject(child.getProjectDirectory()));
        }
        return ImmutableDomainObjectSet.of((Iterable)rendirectedChildren);
    }

    @Override
    public EclipseProject getParent() {
        EclipseProject parent = super.getParent();
        if (parent == null) {
            return null;
        }
        return this.redirectedProjectLookup.getRedirectedProject(parent.getProjectDirectory());
    }

    @Override
    public DomainObjectSet<? extends EclipseProjectDependency> getProjectDependencies() {
        DomainObjectSet<? extends EclipseProjectDependency> projectDependencies = super.getProjectDependencies();
        HashSet redirectedDependencies = Sets.newHashSet();
        for (EclipseProjectDependency projectDependency : projectDependencies) {
            redirectedDependencies.add(new RedirectionAwareEclipseProjectDependency(projectDependency, this.redirectedProjectLookup));
        }
        return ImmutableDomainObjectSet.of((Iterable)redirectedDependencies);
    }
}

