/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.configuration.internal;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.gradleware.tooling.toolingmodel.Path;
import java.util.HashMap;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.configuration.GradleProjectNature;
import org.eclipse.buildship.core.configuration.ProjectConfiguration;
import org.eclipse.buildship.core.configuration.ProjectConfigurationManager;
import org.eclipse.buildship.core.configuration.internal.DefaultProjectConfigurationPersistence;
import org.eclipse.buildship.core.configuration.internal.LegacyCleaningProjectConfigurationPersistence;
import org.eclipse.buildship.core.configuration.internal.ProjectConfigurationPersistence;
import org.eclipse.buildship.core.workspace.WorkspaceOperations;
import org.eclipse.core.resources.IProject;

public final class DefaultProjectConfigurationManager
implements ProjectConfigurationManager {
    private final WorkspaceOperations workspaceOperations;
    private final ProjectConfigurationPersistence projectConfigurationPersistence;

    public DefaultProjectConfigurationManager(WorkspaceOperations workspaceOperations) {
        this.workspaceOperations = workspaceOperations;
        this.projectConfigurationPersistence = new LegacyCleaningProjectConfigurationPersistence(new DefaultProjectConfigurationPersistence());
    }

    @Override
    public ImmutableSet<ProjectConfiguration> getRootProjectConfigurations() {
        ImmutableSet.Builder rootConfigurations = ImmutableSet.builder();
        for (IProject workspaceProject : this.workspaceOperations.getAllProjects()) {
            if (!workspaceProject.isOpen() || !GradleProjectNature.isPresentOn(workspaceProject)) continue;
            ProjectConfiguration projectConfiguration = this.projectConfigurationPersistence.readProjectConfiguration(workspaceProject);
            ProjectConfiguration rootProjectConfiguration = ProjectConfiguration.from(projectConfiguration.getRequestAttributes(), Path.from((String)":"));
            rootConfigurations.add((Object)rootProjectConfiguration);
        }
        HashMap rootProjectDirs = Maps.newHashMap();
        for (ProjectConfiguration rootProjectConfiguration : rootConfigurations.build()) {
            String rootProjectDirPath = rootProjectConfiguration.getRequestAttributes().getProjectDir().getAbsolutePath();
            if (!rootProjectDirs.containsKey(rootProjectDirPath)) {
                rootProjectDirs.put(rootProjectDirPath, rootProjectConfiguration);
                continue;
            }
            throw new GradlePluginsRuntimeException(String.format("Inconsistent Gradle project configuration for project at %s.", rootProjectDirPath));
        }
        return rootConfigurations.build();
    }

    @Override
    public ImmutableSet<ProjectConfiguration> getAllProjectConfigurations() {
        ImmutableSet.Builder allConfigurations = ImmutableSet.builder();
        for (IProject workspaceProject : this.workspaceOperations.getAllProjects()) {
            if (!workspaceProject.isOpen() || !GradleProjectNature.isPresentOn(workspaceProject)) continue;
            ProjectConfiguration projectConfiguration = this.projectConfigurationPersistence.readProjectConfiguration(workspaceProject);
            allConfigurations.add((Object)projectConfiguration);
        }
        return allConfigurations.build();
    }

    @Override
    public void saveProjectConfiguration(ProjectConfiguration projectConfiguration, IProject workspaceProject) {
        this.projectConfigurationPersistence.saveProjectConfiguration(projectConfiguration, workspaceProject);
    }

    @Override
    public ProjectConfiguration readProjectConfiguration(IProject workspaceProject) {
        return this.projectConfigurationPersistence.readProjectConfiguration(workspaceProject);
    }

    @Override
    public void deleteProjectConfiguration(IProject workspaceProject) {
        this.projectConfigurationPersistence.deleteProjectConfiguration(workspaceProject);
    }
}

