/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.util.selection;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Control;

public final class Enabler {
    private final Button button;
    private final List<Control> controls;
    private final SelectionListener selectionListener;

    public Enabler(Button button) {
        this.button = button;
        this.controls = Lists.newArrayList();
        this.selectionListener = new ButtonSelectionListener();
        this.button.addSelectionListener(this.selectionListener);
    }

    public void enables(Control ... controls) {
        this.controls.addAll((Collection<Control>)ImmutableList.copyOf((Object[])controls));
        this.updateEnabledStateOfTargetControls();
    }

    private void updateEnabledStateOfTargetControls() {
        boolean enabled = this.button.getSelection();
        for (Control control : this.controls) {
            control.setEnabled(enabled);
            if (!enabled) continue;
            control.setFocus();
        }
    }

    public void dispose() {
        this.button.removeSelectionListener(this.selectionListener);
    }

    private final class ButtonSelectionListener
    implements SelectionListener {
        private ButtonSelectionListener() {
        }

        public void widgetSelected(SelectionEvent e) {
            Enabler.this.updateEnabledStateOfTargetControls();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            Enabler.this.updateEnabledStateOfTargetControls();
        }
    }
}

