/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.eclipse.buildship.core.AggregateException;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.util.progress.AsyncHandler;
import org.eclipse.buildship.core.util.progress.ToolingApiJob;
import org.eclipse.buildship.core.workspace.NewProjectHandler;
import org.eclipse.buildship.core.workspace.internal.SynchronizeGradleBuildJob;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.jobs.Job;

final class SynchronizeGradleBuildsJob
extends ToolingApiJob {
    private final ImmutableSet<FixedRequestAttributes> builds;
    private final NewProjectHandler newProjectHandler;
    private final ImmutableSet<SynchronizeGradleBuildJob> jobs;

    public SynchronizeGradleBuildsJob(Set<FixedRequestAttributes> builds, NewProjectHandler newProjectHandler) {
        super("Synchronize Gradle builds", true);
        this.builds = ImmutableSet.copyOf(builds);
        this.newProjectHandler = (NewProjectHandler)Preconditions.checkNotNull((Object)newProjectHandler);
        ImmutableSet.Builder jobs = ImmutableSet.builder();
        for (FixedRequestAttributes build : builds) {
            jobs.add((Object)new SynchronizeGradleBuildJob(build, newProjectHandler, AsyncHandler.NO_OP));
        }
        this.jobs = jobs.build();
    }

    @Override
    protected void runToolingApiJob(IProgressMonitor monitor) throws Exception {
        this.scheduleJobs();
        this.waitForJobsToFinish();
        this.handleResults();
    }

    private void scheduleJobs() {
        for (SynchronizeGradleBuildJob job : this.jobs) {
            job.schedule();
        }
    }

    private void waitForJobsToFinish() throws InterruptedException {
        for (SynchronizeGradleBuildJob job : this.jobs) {
            job.join();
        }
    }

    private void handleResults() {
        ArrayList errors = Lists.newArrayList();
        for (SynchronizeGradleBuildJob job : this.jobs) {
            Throwable error;
            IStatus status = job.getResult();
            if (status == null) continue;
            if (status.matches(8)) {
                throw new OperationCanceledException();
            }
            if (status.isOK() || (error = status.getException()) == null) continue;
            errors.add(error);
        }
        this.propagate(errors);
    }

    private void propagate(List<Throwable> errors) {
        if (errors.size() == 1) {
            Throwable e = errors.get(0);
            Throwables.propagateIfPossible((Throwable)e);
            throw new GradlePluginsRuntimeException(e);
        }
        if (errors.size() > 1) {
            throw new AggregateException(errors);
        }
    }

    @Override
    protected void canceling() {
        for (SynchronizeGradleBuildJob job : this.jobs) {
            job.cancel();
        }
    }

    public boolean shouldSchedule() {
        for (Job job : Job.getJobManager().find((Object)"org.eclipse.buildship.core.jobs")) {
            if (!(job instanceof SynchronizeGradleBuildsJob) || !this.isCoveredBy((SynchronizeGradleBuildsJob)job)) continue;
            return false;
        }
        return true;
    }

    private boolean isCoveredBy(SynchronizeGradleBuildsJob other) {
        return Objects.equal(this.builds, other.builds) && (this.newProjectHandler == NewProjectHandler.NO_OP || Objects.equal((Object)this.newProjectHandler, (Object)other.newProjectHandler));
    }
}

