/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.configuration.internal;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.Map;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.configuration.ProjectConfiguration;
import org.eclipse.buildship.core.configuration.internal.ProjectConfigurationPersistence;
import org.eclipse.buildship.core.configuration.internal.ProjectConfigurationProperties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.osgi.service.prefs.BackingStoreException;

final class LegacyCleaningProjectConfigurationPersistence
implements ProjectConfigurationPersistence {
    private static final String LEGACY_GRADLE_PREFERENCES_LOCATION = ".settings/gradle.prefs";
    private static final String LEGACY_GRADLE_PREFERENCES_FILE_NAME_WITHOUT_EXTENSION = "gradle";
    private final ProjectConfigurationPersistence delegate;

    LegacyCleaningProjectConfigurationPersistence(ProjectConfigurationPersistence delegate) {
        this.delegate = (ProjectConfigurationPersistence)Preconditions.checkNotNull((Object)delegate);
    }

    @Override
    public void saveProjectConfiguration(ProjectConfiguration configuration, IProject project) {
        LegacyCleaningProjectConfigurationPersistence.cleanupLegacyConfiguration(project);
        this.delegate.saveProjectConfiguration(configuration, project);
    }

    @Override
    public void deleteProjectConfiguration(IProject project) {
        this.delegate.deleteProjectConfiguration(project);
    }

    @Override
    public ProjectConfiguration readProjectConfiguration(IProject project) {
        if (LegacyCleaningProjectConfigurationPersistence.hasLegacyConfiguration(project)) {
            return LegacyCleaningProjectConfigurationPersistence.readLegacyProjectConfiguration(project);
        }
        return this.delegate.readProjectConfiguration(project);
    }

    private static boolean hasLegacyConfiguration(IProject project) {
        return LegacyCleaningProjectConfigurationPersistence.getLegacyConfigurationFile(project).exists();
    }

    private static File getLegacyConfigurationFile(IProject project) {
        return new File(project.getLocation().toFile(), LEGACY_GRADLE_PREFERENCES_LOCATION);
    }

    private static ProjectConfiguration readLegacyProjectConfiguration(IProject workspaceProject) {
        return LegacyCleaningProjectConfigurationPersistence.readLegacyConfiguration(workspaceProject).toProjectConfiguration(workspaceProject);
    }

    private static ProjectConfigurationProperties readLegacyConfiguration(IProject project) {
        Map<String, Map<String, String>> parsedJson = LegacyCleaningProjectConfigurationPersistence.parseLegacyConfigurationFile(project);
        Map<String, String> config = parsedJson.get("1.0");
        String projectPath = config.get("project_path");
        String projectDir = config.get("connection_project_dir");
        String gradleUserHome = config.get("connection_gradle_user_home");
        String gradleDistribution = config.get("connection_gradle_distribution");
        String javaHome = config.get("connection_java_home");
        String jvmArguments = config.get("connection_jvm_arguments");
        String arguments = config.get("connection_arguments");
        return ProjectConfigurationProperties.from(projectPath, projectDir, gradleUserHome, gradleDistribution, javaHome, jvmArguments, arguments);
    }

    private static Map<String, Map<String, String>> parseLegacyConfigurationFile(IProject project) {
        File gradlePrefsFile = LegacyCleaningProjectConfigurationPersistence.getLegacyConfigurationFile(project);
        String malformedFileMessage = String.format("Project %s contains a malformed gradle.prefs file. Please re-run the import wizard.", project.getName());
        Map parsedJson = null;
        try {
            String json = Files.toString((File)gradlePrefsFile, (Charset)Charsets.UTF_8);
            Gson gson = new GsonBuilder().create();
            parsedJson = (Map)gson.fromJson(json, LegacyCleaningProjectConfigurationPersistence.createMapTypeToken());
        }
        catch (Exception e) {
            throw new GradlePluginsRuntimeException(malformedFileMessage, e);
        }
        if (parsedJson == null) {
            throw new GradlePluginsRuntimeException(malformedFileMessage);
        }
        return parsedJson;
    }

    private static Type createMapTypeToken() {
        return new TypeToken<Map<String, Map<String, String>>>(){}.getType();
    }

    private static void cleanupLegacyConfiguration(IProject project) {
        Preconditions.checkNotNull((Object)project);
        Preconditions.checkArgument((boolean)project.isAccessible());
        if (LegacyCleaningProjectConfigurationPersistence.hasLegacyConfiguration(project)) {
            LegacyCleaningProjectConfigurationPersistence.removeLegacyPreferencesFromPreferenceStore(project);
            LegacyCleaningProjectConfigurationPersistence.deleteLegacyPreferencesFromEclipseFileSystem(project);
            LegacyCleaningProjectConfigurationPersistence.deleteLegacyPreferenceFileFromJavaIoFileSystem(project);
        }
    }

    private static void removeLegacyPreferencesFromPreferenceStore(IProject project) {
        try {
            ProjectScope projectScope = new ProjectScope(project);
            IEclipsePreferences node = projectScope.getNode(LEGACY_GRADLE_PREFERENCES_FILE_NAME_WITHOUT_EXTENSION);
            if (node != null) {
                node.removeNode();
            }
        }
        catch (BackingStoreException e) {
            throw new GradlePluginsRuntimeException(LegacyCleaningProjectConfigurationPersistence.getCouldNotDeleteMessage(project), e);
        }
    }

    private static void deleteLegacyPreferencesFromEclipseFileSystem(IProject project) {
        try {
            IFile legacyConfigurationFile = project.getFile(LEGACY_GRADLE_PREFERENCES_LOCATION);
            if (legacyConfigurationFile.exists()) {
                legacyConfigurationFile.delete(true, null);
            }
        }
        catch (CoreException e) {
            throw new GradlePluginsRuntimeException(LegacyCleaningProjectConfigurationPersistence.getCouldNotDeleteMessage(project), e);
        }
    }

    private static void deleteLegacyPreferenceFileFromJavaIoFileSystem(IProject project) {
        boolean deleted;
        File legacyConfigurationFile = LegacyCleaningProjectConfigurationPersistence.getLegacyConfigurationFile(project);
        if (legacyConfigurationFile.exists() && !(deleted = legacyConfigurationFile.delete())) {
            throw new GradlePluginsRuntimeException(LegacyCleaningProjectConfigurationPersistence.getCouldNotDeleteMessage(project));
        }
    }

    private static String getCouldNotDeleteMessage(IProject project) {
        return String.format("Cannot clean up legacy project configuration for project %s.", project.getName());
    }
}

