/*
 * Decompiled with CFR 0.152.
 */
package com.gradleware.tooling.toolingmodel.buildaction;

import com.google.common.base.Preconditions;
import com.gradleware.tooling.toolingmodel.buildaction.DoubleBuildAction;
import com.gradleware.tooling.toolingmodel.buildaction.GlobalModelBuildAction;
import com.gradleware.tooling.toolingmodel.buildaction.ModelForAllProjectsBuildAction;
import com.gradleware.tooling.toolingmodel.buildaction.ModelForSingleProjectBuildAction;
import com.gradleware.tooling.toolingmodel.buildaction.TripleBuildAction;
import org.gradle.tooling.BuildAction;

public final class BuildActionFactory {
    public static <T> ModelForSingleProjectBuildAction<T> getModelForProject(String projectPath, Class<T> modelType) {
        Preconditions.checkNotNull((Object)projectPath);
        Preconditions.checkNotNull(modelType);
        return new ModelForSingleProjectBuildAction<T>(projectPath, modelType);
    }

    public static <T> ModelForAllProjectsBuildAction<T> getModelForAllProjects(Class<T> modelType) {
        Preconditions.checkNotNull(modelType);
        return new ModelForAllProjectsBuildAction<T>(modelType);
    }

    public static <T> GlobalModelBuildAction<T> getBuildModel(Class<T> modelType) {
        Preconditions.checkNotNull(modelType);
        return new GlobalModelBuildAction<T>(modelType);
    }

    public static <S, T> DoubleBuildAction<S, T> getPairResult(BuildAction<S> first, BuildAction<T> second) {
        Preconditions.checkNotNull(first);
        Preconditions.checkNotNull(second);
        return new DoubleBuildAction<S, T>(first, second);
    }

    public static <S, T, U> TripleBuildAction<S, T, U> getTripleResult(BuildAction<S> first, BuildAction<T> second, BuildAction<U> third) {
        Preconditions.checkNotNull(first);
        Preconditions.checkNotNull(second);
        Preconditions.checkNotNull(third);
        return new TripleBuildAction<S, T, U>(first, second, third);
    }
}

