/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.composite.internal;

import com.google.common.collect.Sets;
import java.util.HashSet;
import org.gradle.tooling.composite.internal.DelegatingEclipseProject;
import org.gradle.tooling.composite.internal.RedirectedProjectLookup;
import org.gradle.tooling.composite.internal.RedirectionAwareEclipseProjectDependency;
import org.gradle.tooling.model.DomainObjectSet;
import org.gradle.tooling.model.eclipse.EclipseProject;
import org.gradle.tooling.model.eclipse.EclipseProjectDependency;
import org.gradle.tooling.model.eclipse.HierarchicalEclipseProject;
import org.gradle.tooling.model.internal.ImmutableDomainObjectSet;

public class RedirectionAwareEclipseProject
extends DelegatingEclipseProject {
    private final RedirectedProjectLookup redirectedProjectLookup;

    public RedirectionAwareEclipseProject(EclipseProject original, RedirectedProjectLookup redirectedProjectLookup) {
        super(original);
        this.redirectedProjectLookup = redirectedProjectLookup;
    }

    @Override
    public DomainObjectSet<? extends EclipseProject> getChildren() {
        DomainObjectSet<? extends EclipseProject> children = super.getChildren();
        HashSet rendirectedChildren = Sets.newHashSet();
        for (EclipseProject child : children) {
            rendirectedChildren.add(this.redirectedProjectLookup.getRedirectedProject((HierarchicalEclipseProject)child));
        }
        return ImmutableDomainObjectSet.of((Iterable)rendirectedChildren);
    }

    @Override
    public EclipseProject getParent() {
        return this.redirectedProjectLookup.getRedirectedProject((HierarchicalEclipseProject)super.getParent());
    }

    @Override
    public DomainObjectSet<? extends EclipseProjectDependency> getProjectDependencies() {
        DomainObjectSet<? extends EclipseProjectDependency> projectDependencies = super.getProjectDependencies();
        HashSet redirectedDependencies = Sets.newHashSet();
        for (EclipseProjectDependency projectDependency : projectDependencies) {
            redirectedDependencies.add(new RedirectionAwareEclipseProjectDependency(projectDependency, this.redirectedProjectLookup));
        }
        return ImmutableDomainObjectSet.of((Iterable)redirectedDependencies);
    }
}

