/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.gradleware.tooling.toolingmodel.OmniEclipseGradleBuild;
import com.gradleware.tooling.toolingmodel.repository.FetchStrategy;
import com.gradleware.tooling.toolingmodel.repository.FixedRequestAttributes;
import com.gradleware.tooling.toolingmodel.repository.SimpleModelRepository;
import com.gradleware.tooling.toolingmodel.repository.TransientRequestAttributes;
import java.util.List;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.console.ProcessStreams;
import org.eclipse.buildship.core.util.progress.AsyncHandler;
import org.eclipse.buildship.core.util.progress.DelegatingProgressListener;
import org.eclipse.buildship.core.util.progress.ToolingApiWorkspaceJob;
import org.eclipse.buildship.core.workspace.NewProjectHandler;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;

public final class SynchronizeGradleProjectJob
extends ToolingApiWorkspaceJob {
    private final FixedRequestAttributes rootRequestAttributes;
    private final NewProjectHandler newProjectHandler;
    private final AsyncHandler initializer;

    public SynchronizeGradleProjectJob(FixedRequestAttributes rootRequestAttributes, List<String> unused, AsyncHandler initializer) {
        this(rootRequestAttributes, NewProjectHandler.IMPORT_AND_MERGE, initializer);
    }

    public SynchronizeGradleProjectJob(FixedRequestAttributes rootRequestAttributes, NewProjectHandler newProjectHandler, AsyncHandler initializer) {
        this(rootRequestAttributes, newProjectHandler, initializer, false);
    }

    public SynchronizeGradleProjectJob(FixedRequestAttributes rootRequestAttributes, NewProjectHandler newProjectHandler, AsyncHandler initializer, boolean showUserNotifications) {
        super(String.format("Synchronize Gradle root project at %s with workspace", ((FixedRequestAttributes)Preconditions.checkNotNull((Object)rootRequestAttributes)).getProjectDir().getAbsolutePath()), showUserNotifications);
        this.rootRequestAttributes = (FixedRequestAttributes)Preconditions.checkNotNull((Object)rootRequestAttributes);
        this.newProjectHandler = (NewProjectHandler)Preconditions.checkNotNull((Object)newProjectHandler);
        this.initializer = (AsyncHandler)Preconditions.checkNotNull((Object)initializer);
        this.setUser(true);
        this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
    }

    @Override
    protected void runToolingApiJobInWorkspace(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)10);
        this.initializer.run((IProgressMonitor)progress.newChild(1), this.getToken());
        OmniEclipseGradleBuild gradleBuild = this.forceReloadEclipseGradleBuild(this.rootRequestAttributes, progress.newChild(4));
        CorePlugin.workspaceGradleOperations().synchronizeGradleBuildWithWorkspace(gradleBuild, this.rootRequestAttributes, this.newProjectHandler, (IProgressMonitor)progress.newChild(5));
    }

    private OmniEclipseGradleBuild forceReloadEclipseGradleBuild(FixedRequestAttributes requestAttributes, SubMonitor monitor) {
        ProcessStreams streams = CorePlugin.processStreamsProvider().getBackgroundJobProcessStreams();
        ImmutableList listeners = ImmutableList.of((Object)DelegatingProgressListener.withoutDuplicateLifecycleEvents((IProgressMonitor)monitor));
        TransientRequestAttributes transientAttributes = new TransientRequestAttributes(false, streams.getOutput(), streams.getError(), streams.getInput(), (List)listeners, (List)ImmutableList.of(), this.getToken());
        SimpleModelRepository repository = CorePlugin.modelRepositoryProvider().getModelRepository(requestAttributes);
        return repository.fetchEclipseGradleBuild(transientAttributes, FetchStrategy.FORCE_RELOAD);
    }

    @Override
    public boolean belongsTo(Object family) {
        return super.belongsTo(family) || this.getJobFamily().equals(family);
    }

    private String getJobFamily() {
        return SynchronizeGradleProjectJob.class.getName();
    }

    public boolean shouldSchedule() {
        for (Job job : Job.getJobManager().find((Object)this.getJobFamily())) {
            if (!(job instanceof SynchronizeGradleProjectJob) || !this.isCoveredBy((SynchronizeGradleProjectJob)job)) continue;
            return false;
        }
        return true;
    }

    private boolean isCoveredBy(SynchronizeGradleProjectJob other) {
        return !(!Objects.equal((Object)this.rootRequestAttributes, (Object)other.rootRequestAttributes) || this.newProjectHandler != NewProjectHandler.NO_OP && !Objects.equal((Object)this.newProjectHandler, (Object)other.newProjectHandler) || this.initializer != AsyncHandler.NO_OP && !Objects.equal((Object)this.initializer, (Object)other.initializer));
    }
}

