/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.parameters;

import java.util.LinkedList;
import java.util.List;
import org.gradle.internal.event.ListenerBroadcast;
import org.gradle.tooling.ProgressEvent;
import org.gradle.tooling.ProgressListener;
import org.gradle.tooling.internal.protocol.ProgressListenerVersion1;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ProgressListenerAdapter
implements ProgressListenerVersion1 {
    private final ListenerBroadcast<ProgressListener> listeners = new ListenerBroadcast<ProgressListener>(ProgressListener.class);
    private final LinkedList<String> stack = new LinkedList();

    ProgressListenerAdapter(List<ProgressListener> listeners) {
        this.listeners.addAll(listeners);
    }

    @Override
    public void onOperationStart(String description) {
        this.stack.addFirst(description == null ? "" : description);
        this.fireChangeEvent();
    }

    @Override
    public void onOperationEnd() {
        this.stack.removeFirst();
        this.fireChangeEvent();
    }

    private void fireChangeEvent() {
        final String description = this.stack.isEmpty() ? "" : this.stack.getFirst();
        this.listeners.getSource().statusChanged(new ProgressEvent(){

            public String getDescription() {
                return description;
            }
        });
    }
}

