/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.util.List;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.core.resources.FileInfoMatcherDescription;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResourceFilterDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;

final class ResourceFilter {
    private static final String MATCHER_ID = "org.eclipse.core.resources.regexFilterMatcher";
    private static final String OR_ID = "org.eclipse.ui.ide.orFilterMatcher";

    private ResourceFilter() {
    }

    public static void attachFilters(IProject project, List<File> childLocations, IProgressMonitor monitor) {
        monitor = (IProgressMonitor)MoreObjects.firstNonNull((Object)monitor, (Object)new NullProgressMonitor());
        List<FileInfoMatcherDescription> filters = ResourceFilter.createFilters(project, childLocations);
        ResourceFilter.setFilters(project, filters, monitor);
    }

    private static List<FileInfoMatcherDescription> createFilters(IProject project, List<File> children) {
        ImmutableList.Builder filters = ImmutableList.builder();
        IPath projectLocation = project.getLocation();
        for (File child : children) {
            Path childLocation = new Path(child.getAbsolutePath());
            if (!projectLocation.isPrefixOf((IPath)childLocation)) continue;
            filters.add((Object)new FileInfoMatcherDescription(MATCHER_ID, (Object)childLocation.makeRelativeTo(projectLocation).toPortableString()));
        }
        return filters.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setFilters(IProject project, List<FileInfoMatcherDescription> filters, IProgressMonitor monitor) {
        block10: {
            monitor.beginTask(String.format("Set resource filters for project %s", project), 2);
            try {
                IResourceFilterDescription[] currentFilters;
                try {
                    currentFilters = project.getFilters();
                }
                catch (CoreException e) {
                    String message = String.format("Cannot retrieve current resource filters for project %s.", project.getName());
                    throw new GradlePluginsRuntimeException(message, (Exception)((Object)e));
                }
                for (IResourceFilterDescription filter : currentFilters) {
                    try {
                        filter.delete(128, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    catch (CoreException e) {
                        String message = String.format("Cannot delete current resource filter %s.", filter);
                        throw new GradlePluginsRuntimeException(message, (Exception)((Object)e));
                    }
                }
                if (filters.isEmpty()) break block10;
                try {
                    project.createFilter(26, ResourceFilter.createCompositeFilter(filters), 128, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                }
                catch (CoreException e) {
                    String message = String.format("Cannot create new resource filters for project %s.", project);
                    throw new GradlePluginsRuntimeException(message, (Exception)((Object)e));
                }
            }
            finally {
                monitor.done();
            }
        }
    }

    private static FileInfoMatcherDescription createCompositeFilter(List<FileInfoMatcherDescription> filters) {
        return new FileInfoMatcherDescription(OR_ID, (Object)filters.toArray(new FileInfoMatcherDescription[filters.size()]));
    }
}

