/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.internal.project;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.buildship.core.BuildConfiguration;
import org.eclipse.buildship.core.GradleBuild;
import org.eclipse.buildship.core.GradleCore;
import org.eclipse.buildship.core.internal.configuration.GradleProjectNature;
import org.eclipse.buildship.core.internal.workspace.NewProjectHandler;
import org.eclipse.buildship.core.internal.workspace.SynchronizationJob;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.wizards.datatransfer.ProjectConfigurator;

public class GradleProjectConfigurator
implements ProjectConfigurator {
    private static final String[] ROOT_FILES = new String[]{"settings.gradle", "settings.gradle.kts", "gradle.properties"};

    public Set<File> findConfigurableLocations(File root, IProgressMonitor monitor) {
        if (this.isGradleRoot(root)) {
            ImmutableSet.of((Object)root);
        }
        return ImmutableSet.of();
    }

    public void removeDirtyDirectories(Map<File, List<ProjectConfigurator>> proposals) {
        HashSet<File> gradleRoots = new HashSet<File>();
        HashSet<File> nonGradleRoots = new HashSet<File>();
        for (Map.Entry<File, List<ProjectConfigurator>> entry : proposals.entrySet()) {
            File root = entry.getKey();
            if (this.isGradleRoot(root)) {
                entry.getValue().removeIf(pc -> !(pc instanceof GradleProjectConfigurator));
                gradleRoots.add(root);
                continue;
            }
            nonGradleRoots.add(root);
        }
        if (!gradleRoots.isEmpty()) {
            for (File file : nonGradleRoots) {
                proposals.remove(file);
            }
        }
    }

    private boolean isGradleRoot(File root) {
        if (root != null) {
            for (String file : ROOT_FILES) {
                if (!new File(root, file).isFile()) continue;
                return true;
            }
        }
        return false;
    }

    public boolean shouldBeAnEclipseProject(IContainer container, IProgressMonitor monitor) {
        return false;
    }

    public Set<IFolder> getFoldersToIgnore(IProject project, IProgressMonitor monitor) {
        return ImmutableSet.of();
    }

    public boolean canConfigure(IProject project, Set<IPath> ignoredPaths, IProgressMonitor monitor) {
        IPath location = project.getLocation();
        if (location != null) {
            return this.isGradleRoot(location.toFile());
        }
        return false;
    }

    public void configure(IProject project, Set<IPath> ignoredPaths, IProgressMonitor monitor) {
        if (!GradleProjectNature.isPresentOn((IProject)project)) {
            BuildConfiguration buildConfig = BuildConfiguration.forRootProjectDirectory((File)project.getLocation().toFile()).build();
            GradleBuild build = GradleCore.getWorkspace().createBuild(buildConfig);
            new SynchronizationJob(NewProjectHandler.IMPORT_AND_MERGE, (Iterable)ImmutableList.of((Object)build)).schedule();
        }
    }
}

