/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.preferences;

import com.google.common.base.Charsets;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import org.eclipse.buildship.core.internal.CorePlugin;
import org.eclipse.buildship.core.internal.configuration.GradleProjectNature;
import org.eclipse.buildship.core.internal.event.Event;
import org.eclipse.buildship.core.internal.event.EventListener;
import org.eclipse.buildship.core.internal.preferences.AbsentPersistentModel;
import org.eclipse.buildship.core.internal.preferences.ModelPersistence;
import org.eclipse.buildship.core.internal.preferences.PersistentModel;
import org.eclipse.buildship.core.internal.preferences.PersistentModelConverter;
import org.eclipse.buildship.core.internal.workspace.ProjectDeletedEvent;
import org.eclipse.buildship.core.internal.workspace.ProjectMovedEvent;
import org.eclipse.buildship.core.internal.workspace.WorkbenchShutdownEvent;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;

public final class DefaultModelPersistence
implements ModelPersistence,
EventListener {
    private final LoadingCache<IProject, PersistentModel> modelCache;
    private final Object lock = new Object();

    private DefaultModelPersistence() {
        this.modelCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<IProject, PersistentModel>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public PersistentModel load(IProject project) throws Exception {
                Object object = DefaultModelPersistence.this.lock;
                synchronized (object) {
                    return DefaultModelPersistence.doLoadModel(project);
                }
            }
        });
    }

    @Override
    public PersistentModel loadModel(IProject project) {
        return (PersistentModel)this.modelCache.getUnchecked((Object)project);
    }

    @Override
    public void saveModel(PersistentModel model) {
        this.modelCache.put((Object)model.getProject(), (Object)model);
    }

    @Override
    public void deleteModel(IProject project) {
        DefaultModelPersistence.preferencesFile(project).delete();
        this.modelCache.invalidate((Object)project);
    }

    @Override
    public void onEvent(Event event) {
        try {
            if (event instanceof ProjectMovedEvent) {
                this.movePreferencesFile((ProjectMovedEvent)event);
            } else if (event instanceof ProjectDeletedEvent) {
                this.deleteProjectPreferences((ProjectDeletedEvent)event);
            } else if (event instanceof WorkbenchShutdownEvent) {
                this.persistAllProjectPrefs();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void movePreferencesFile(ProjectMovedEvent event) throws IOException {
        String previousName = event.getPreviousName();
        for (IProject cached : this.modelCache.asMap().keySet()) {
            if (!cached.getName().equals(previousName)) continue;
            PersistentModel model = (PersistentModel)this.modelCache.getUnchecked((Object)cached);
            if (model.isPresent()) {
                this.modelCache.put((Object)event.getProject(), (Object)model);
            }
            this.modelCache.invalidate((Object)cached);
        }
        File preferencesFile = DefaultModelPersistence.preferencesFile(event.getPreviousName());
        if (preferencesFile.exists()) {
            Files.move((File)preferencesFile, (File)DefaultModelPersistence.preferencesFile(event.getProject().getName()));
        }
    }

    private void deleteProjectPreferences(ProjectDeletedEvent event) {
        this.deleteModel(event.getProject());
    }

    private static PersistentModel doLoadModel(IProject project) throws IOException, FileNotFoundException {
        String projectName = project.getName();
        File preferencesFile = DefaultModelPersistence.preferencesFile(projectName);
        if (preferencesFile.exists()) {
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(DefaultModelPersistence.preferencesFile(projectName)), Charsets.UTF_8);){
                Properties props = new Properties();
                props.load(reader);
                PersistentModel persistentModel = PersistentModelConverter.toModel(project, props);
                return persistentModel;
            }
        }
        return new AbsentPersistentModel(project);
    }

    private void persistAllProjectPrefs() {
        ConcurrentMap modelCacheMap = this.modelCache.asMap();
        for (Map.Entry entry : modelCacheMap.entrySet()) {
            PersistentModel model = (PersistentModel)entry.getValue();
            if (!model.isPresent()) continue;
            DefaultModelPersistence.persistPrefs((IProject)entry.getKey(), model);
        }
    }

    private static void persistPrefs(IProject project, PersistentModel model) {
        try {
            DefaultModelPersistence.persistPrefsChecked(project, model);
        }
        catch (IOException e) {
            CorePlugin.logger().warn("Can't save persistent model for project " + project.getName(), e);
        }
    }

    private static void persistPrefsChecked(IProject project, PersistentModel model) throws IOException {
        File preferencesFile = DefaultModelPersistence.preferencesFile(project);
        if (!preferencesFile.exists()) {
            Files.createParentDirs((File)preferencesFile);
            Files.touch((File)preferencesFile);
        }
        Properties props = PersistentModelConverter.toProperties(model);
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(preferencesFile), Charsets.UTF_8);){
            props.store(writer, "");
        }
    }

    private static File preferencesFile(IProject project) {
        return DefaultModelPersistence.preferencesFile(project.getName());
    }

    private static File preferencesFile(String projectName) {
        return CorePlugin.getInstance().getStateLocation().append("project-preferences").append(projectName).toFile();
    }

    public static DefaultModelPersistence createAndRegister() {
        DefaultModelPersistence persistence = new DefaultModelPersistence();
        CorePlugin.listenerRegistry().addEventListener(persistence);
        persistence.prefetchCacheAsync();
        return persistence;
    }

    private void prefetchCacheAsync() {
        Job job = new Job("Load persistent model for all projects"){

            protected IStatus run(IProgressMonitor monitor) {
                for (IProject project : CorePlugin.workspaceOperations().getAllProjects()) {
                    if (!GradleProjectNature.isPresentOn(project)) continue;
                    try {
                        DefaultModelPersistence.this.modelCache.get((Object)project);
                    }
                    catch (ExecutionException e) {
                        CorePlugin.logger().warn("Can't load persistent model for project " + project.getName(), e);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public void close() {
        CorePlugin.listenerRegistry().removeEventListener(this);
    }
}

