/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.buildship.core.workspace.GradleClasspathContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathEntryResolver;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;

public class GradleClasspathContainerRuntimeClasspathEntryResolver
implements IRuntimeClasspathEntryResolver {
    public IRuntimeClasspathEntry[] resolveRuntimeClasspathEntry(IRuntimeClasspathEntry entry, ILaunchConfiguration configuration) throws CoreException {
        if (entry == null || entry.getJavaProject() == null) {
            return new IRuntimeClasspathEntry[0];
        }
        return this.resolveRuntimeClasspathEntry(entry, entry.getJavaProject());
    }

    public IRuntimeClasspathEntry[] resolveRuntimeClasspathEntry(IRuntimeClasspathEntry entry, IJavaProject project) throws CoreException {
        if (entry.getType() != 4 || !entry.getPath().equals((Object)GradleClasspathContainer.CONTAINER_PATH)) {
            return new IRuntimeClasspathEntry[0];
        }
        return GradleClasspathContainerRuntimeClasspathEntryResolver.collectContainerRuntimeClasspathIfPresent(project);
    }

    private static IRuntimeClasspathEntry[] collectContainerRuntimeClasspathIfPresent(IJavaProject project) throws CoreException {
        ArrayList result = Lists.newArrayList();
        GradleClasspathContainerRuntimeClasspathEntryResolver.collectContainerRuntimeClasspathIfPresent(project, result, false);
        return result.toArray(new IRuntimeClasspathEntry[result.size()]);
    }

    private static void collectContainerRuntimeClasspathIfPresent(IJavaProject project, List<IRuntimeClasspathEntry> result, boolean includeExportedEntriesOnly) throws CoreException {
        IClasspathContainer container = JavaCore.getClasspathContainer((IPath)GradleClasspathContainer.CONTAINER_PATH, (IJavaProject)project);
        if (container != null) {
            GradleClasspathContainerRuntimeClasspathEntryResolver.collectContainerRuntimeClasspath(container, result, includeExportedEntriesOnly);
        }
    }

    private static void collectContainerRuntimeClasspath(IClasspathContainer container, List<IRuntimeClasspathEntry> result, boolean includeExportedEntriesOnly) throws CoreException {
        for (IClasspathEntry cpe : container.getClasspathEntries()) {
            Optional<IProject> candidate;
            if (includeExportedEntriesOnly && !cpe.isExported()) continue;
            if (cpe.getEntryKind() == 1) {
                result.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)cpe.getPath()));
                continue;
            }
            if (cpe.getEntryKind() != 2 || !(candidate = GradleClasspathContainerRuntimeClasspathEntryResolver.findAccessibleJavaProject(cpe.getPath().segment(0))).isPresent()) continue;
            IJavaProject dependencyProject = JavaCore.create((IProject)((IProject)candidate.get()));
            IRuntimeClasspathEntry projectRuntimeEntry = JavaRuntime.newProjectRuntimeClasspathEntry((IJavaProject)dependencyProject);
            Collections.addAll(result, JavaRuntime.resolveRuntimeClasspathEntry((IRuntimeClasspathEntry)projectRuntimeEntry, (IJavaProject)dependencyProject));
            GradleClasspathContainerRuntimeClasspathEntryResolver.collectContainerRuntimeClasspathIfPresent(dependencyProject, result, true);
        }
    }

    private static Optional<IProject> findAccessibleJavaProject(String name) {
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(name);
        if (project != null && project.isAccessible() && GradleClasspathContainerRuntimeClasspathEntryResolver.hasJavaNature(project)) {
            return Optional.of((Object)project);
        }
        return Optional.absent();
    }

    private static boolean hasJavaNature(IProject project) {
        try {
            return project.hasNature("org.eclipse.jdt.core.javanature");
        }
        catch (CoreException e) {
            return false;
        }
    }

    public IVMInstall resolveVMInstall(IClasspathEntry entry) throws CoreException {
        return null;
    }
}

