/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.workspace.internal;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.gradleware.tooling.toolingmodel.OmniEclipseProjectNature;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.buildship.core.workspace.internal.StringSetProjectProperty;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;

final class ProjectNatureUpdater {
    private static final String PROJECT_PROPERTY_KEY_GRADLE_NATURES = "natures";
    private final IProject project;
    private final ImmutableList<OmniEclipseProjectNature> natures;

    public ProjectNatureUpdater(IProject project, List<OmniEclipseProjectNature> natures) {
        this.project = (IProject)Preconditions.checkNotNull((Object)project);
        this.natures = ImmutableList.copyOf(natures);
    }

    private void updateNatures(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)2);
        StringSetProjectProperty knownNatures = StringSetProjectProperty.from(this.project, PROJECT_PROPERTY_KEY_GRADLE_NATURES);
        this.removeNaturesRemovedFromGradleModel(knownNatures, progress.newChild(1));
        this.addNaturesNewInGradleModel(knownNatures, progress.newChild(1));
    }

    private void addNaturesNewInGradleModel(StringSetProjectProperty knownNatures, SubMonitor progress) throws CoreException {
        LinkedHashSet newNatureNames = Sets.newLinkedHashSet();
        for (OmniEclipseProjectNature nature : this.natures) {
            String natureId = nature.getId();
            if (!this.natureRecognizedByEclipse(natureId)) continue;
            newNatureNames.add(natureId);
        }
        this.addNatures(this.project, newNatureNames, progress);
        knownNatures.set(newNatureNames);
    }

    private void addNatures(IProject project, Set<String> natureIds, SubMonitor progress) throws CoreException {
        IProjectDescription description = project.getDescription();
        LinkedHashSet newIds = Sets.newLinkedHashSet(Arrays.asList(description.getNatureIds()));
        newIds.addAll(natureIds);
        description.setNatureIds(newIds.toArray(new String[0]));
        project.setDescription(description, (IProgressMonitor)progress);
    }

    private boolean natureRecognizedByEclipse(String natureId) {
        return ResourcesPlugin.getWorkspace().getNatureDescriptor(natureId) != null;
    }

    private void removeNaturesRemovedFromGradleModel(StringSetProjectProperty knownNatures, SubMonitor progress) throws CoreException {
        Set<String> knownNatureIds = knownNatures.get();
        LinkedHashSet naturesToRemove = Sets.newLinkedHashSet();
        for (String knownNatureId : knownNatureIds) {
            if (this.natureIdExistsInGradleModel(knownNatureId)) continue;
            naturesToRemove.add(knownNatureId);
        }
        this.removeNatures(this.project, naturesToRemove, progress);
    }

    private void removeNatures(IProject project, Set<String> natureIds, SubMonitor progress) throws CoreException {
        IProjectDescription description = project.getDescription();
        ArrayList newIds = Lists.newArrayList((Object[])description.getNatureIds());
        newIds.removeAll(natureIds);
        description.setNatureIds(newIds.toArray(new String[0]));
        project.setDescription(description, (IProgressMonitor)progress);
    }

    private boolean natureIdExistsInGradleModel(final String natureId) {
        return FluentIterable.from(this.natures).firstMatch((Predicate)new Predicate<OmniEclipseProjectNature>(){

            public boolean apply(OmniEclipseProjectNature nature) {
                return nature.getId().equals(natureId);
            }
        }).isPresent();
    }

    public static void update(IProject project, Optional<List<OmniEclipseProjectNature>> projectNatures, IProgressMonitor monitor) throws CoreException {
        List natures = (List)projectNatures.or(Collections.emptyList());
        ProjectNatureUpdater updater = new ProjectNatureUpdater(project, natures);
        updater.updateNatures(monitor);
    }
}

