/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.configuration.internal;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import org.eclipse.buildship.core.CorePlugin;
import org.eclipse.buildship.core.GradlePluginsRuntimeException;
import org.eclipse.buildship.core.configuration.ProjectConfiguration;
import org.eclipse.buildship.core.configuration.internal.PreferenceStore;
import org.eclipse.buildship.core.configuration.internal.ProjectConfigurationPersistence;
import org.eclipse.buildship.core.configuration.internal.ProjectConfigurationProperties;
import org.eclipse.core.resources.IProject;

final class DefaultProjectConfigurationPersistence
implements ProjectConfigurationPersistence {
    private static final String PREF_NODE = "org.eclipse.buildship.core";
    private static final String PREF_KEY_PROJECT_PATH = "project.path";
    private static final String PREF_KEY_CONNECTION_PROJECT_DIR = "connection.project.dir";
    private static final String DEPRECATED_PREF_KEY_CONNECTION_GRADLE_USER_HOME = "connection.gradle.user.home";
    private static final String PREF_KEY_CONNECTION_GRADLE_DISTRIBUTION = "connection.gradle.distribution";
    private static final String PREF_KEY_CONNECTION_JAVA_HOME = "connection.java.home";
    private static final String PREF_KEY_CONNECTION_JVM_ARGUMENTS = "connection.jvm.arguments";
    private static final String PREF_KEY_CONNECTION_ARGUMENTS = "connection.arguments";

    DefaultProjectConfigurationPersistence() {
    }

    @Override
    public ProjectConfiguration readProjectConfiguration(IProject project) {
        Preconditions.checkNotNull((Object)project);
        Preconditions.checkArgument((boolean)project.isAccessible());
        try {
            return DefaultProjectConfigurationPersistence.loadFromPreferencesApi(project);
        }
        catch (Exception e1) {
            try {
                return DefaultProjectConfigurationPersistence.loadFromPropertiesFile(project);
            }
            catch (IOException e2) {
                throw new GradlePluginsRuntimeException(String.format("Cannot load project configuration for project %s.", project.getName()), e2);
            }
        }
    }

    private static ProjectConfiguration loadFromPreferencesApi(IProject project) {
        PreferenceStore preferences = PreferenceStore.forProjectScope(project, PREF_NODE);
        return DefaultProjectConfigurationPersistence.readProjectConfiguration(project, preferences);
    }

    private static ProjectConfiguration readProjectConfiguration(IProject project, PreferenceStore preferences) {
        String projectPath = preferences.read(PREF_KEY_PROJECT_PATH);
        String projectDir = preferences.read(PREF_KEY_CONNECTION_PROJECT_DIR);
        File gradleUserHome = CorePlugin.workspaceConfigurationManager().loadWorkspaceConfiguration().getGradleUserHome();
        String gradleUserHomePath = gradleUserHome == null ? null : gradleUserHome.getPath();
        String gradleDistribution = preferences.read(PREF_KEY_CONNECTION_GRADLE_DISTRIBUTION);
        String javaHome = preferences.read(PREF_KEY_CONNECTION_JAVA_HOME, null);
        String jvmArguments = preferences.read(PREF_KEY_CONNECTION_JVM_ARGUMENTS, "");
        String arguments = preferences.read(PREF_KEY_CONNECTION_ARGUMENTS, "");
        return ProjectConfigurationProperties.from(projectPath, projectDir, gradleUserHomePath, gradleDistribution, javaHome, jvmArguments, arguments).toProjectConfiguration(project);
    }

    private static ProjectConfiguration loadFromPropertiesFile(IProject project) throws IOException {
        PreferenceStore preferences = PreferenceStore.forPreferenceFile(DefaultProjectConfigurationPersistence.getProjectPrefsFile(project, PREF_NODE));
        return DefaultProjectConfigurationPersistence.readProjectConfiguration(project, preferences);
    }

    private static File getProjectPrefsFile(IProject project, String node) {
        return new File(project.getLocation().toFile(), ".settings/" + node + ".prefs");
    }

    @Override
    public void saveProjectConfiguration(ProjectConfiguration projectConfiguration, IProject project) {
        Preconditions.checkNotNull((Object)projectConfiguration);
        Preconditions.checkNotNull((Object)project);
        Preconditions.checkArgument((boolean)project.isAccessible());
        ProjectConfigurationProperties properties = ProjectConfigurationProperties.from(project, projectConfiguration);
        try {
            PreferenceStore preferences = PreferenceStore.forProjectScope(project, PREF_NODE);
            preferences.write(PREF_KEY_PROJECT_PATH, properties.getProjectPath());
            preferences.write(PREF_KEY_CONNECTION_PROJECT_DIR, properties.getProjectDir());
            preferences.delete(DEPRECATED_PREF_KEY_CONNECTION_GRADLE_USER_HOME);
            preferences.write(PREF_KEY_CONNECTION_GRADLE_DISTRIBUTION, properties.getGradleDistribution());
            preferences.write(PREF_KEY_CONNECTION_JAVA_HOME, properties.getJavaHome());
            preferences.write(PREF_KEY_CONNECTION_JVM_ARGUMENTS, properties.getJvmArguments());
            preferences.write(PREF_KEY_CONNECTION_ARGUMENTS, properties.getArguments());
            preferences.flush();
        }
        catch (Exception e) {
            throw new GradlePluginsRuntimeException(String.format("Cannot store project-scope preferences in project %s.", project.getName()), e);
        }
    }

    @Override
    public void deleteProjectConfiguration(IProject project) {
        Preconditions.checkNotNull((Object)project);
        Preconditions.checkArgument((boolean)project.isAccessible());
        try {
            PreferenceStore preferences = PreferenceStore.forProjectScope(project, PREF_NODE);
            preferences.delete(PREF_KEY_PROJECT_PATH);
            preferences.delete(PREF_KEY_CONNECTION_PROJECT_DIR);
            preferences.delete(DEPRECATED_PREF_KEY_CONNECTION_GRADLE_USER_HOME);
            preferences.delete(PREF_KEY_CONNECTION_GRADLE_DISTRIBUTION);
            preferences.delete(PREF_KEY_CONNECTION_JAVA_HOME);
            preferences.delete(PREF_KEY_CONNECTION_JVM_ARGUMENTS);
            preferences.delete(PREF_KEY_CONNECTION_ARGUMENTS);
            preferences.flush();
        }
        catch (Exception e) {
            throw new GradlePluginsRuntimeException(String.format("Cannot delete project-scope preferences in project %s.", project.getName()), e);
        }
    }
}

