/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.converters;

import java.io.Serializable;
import org.gradle.api.Action;
import org.gradle.tooling.internal.adapter.SourceObjectMapping;
import org.gradle.tooling.internal.consumer.converters.CompatibilityIdeaProjectMapping;
import org.gradle.tooling.internal.consumer.versioning.VersionDetails;
import org.gradle.tooling.model.idea.IdeaProject;
import org.gradle.util.GradleVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IdeaProjectCompatibilityMapper
implements Action<SourceObjectMapping>,
Serializable {
    private final VersionDetails versionDetails;

    public IdeaProjectCompatibilityMapper(VersionDetails versionDetails) {
        this.versionDetails = versionDetails;
    }

    @Override
    public void execute(SourceObjectMapping mapping) {
        Class<?> targetType = mapping.getTargetType();
        if (IdeaProject.class.isAssignableFrom(targetType) && !this.versionSupportsIdeaJavaSourceSettings()) {
            mapping.mixIn(CompatibilityIdeaProjectMapping.class);
        }
    }

    private boolean versionSupportsIdeaJavaSourceSettings() {
        GradleVersion targetGradleVersion = GradleVersion.version(this.versionDetails.getVersion());
        return targetGradleVersion.getBaseVersion().compareTo(GradleVersion.version("2.11")) >= 0;
    }
}

