/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.ui.notification;

import com.google.common.base.Preconditions;
import com.google.common.collect.FluentIterable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.buildship.ui.UiPlugin;
import org.eclipse.buildship.ui.i18n.UiMessages;
import org.eclipse.buildship.ui.util.font.FontUtils;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.PlatformUI;

public final class ExceptionDetailsDialog
extends Dialog {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static final int COPY_EXCEPTION_BUTTON_ID = 25;
    private final String title;
    private final String message;
    private final String details;
    private final ArrayList<Throwable> throwables;
    private Image image;
    private Button detailsButton;
    private Composite stackTraceAreaControl;
    private Label singleErrorMessageLabel;
    private TableViewer exceptionsViewer;
    private Label singleErrorDetailsLabel;
    private Label multiErrorMessageLabel;
    private Clipboard clipboard;
    private Text stacktraceAreaText;
    private Composite singleErrorContainer;
    private Composite multiErrorContainer;
    private StackLayout stackLayout;

    public ExceptionDetailsDialog(Shell shell, String title, String message, String details, int severity, Throwable throwable) {
        super((IShellProvider)new SameShellProvider((Control)shell));
        this.title = (String)Preconditions.checkNotNull((Object)title);
        this.message = (String)Preconditions.checkNotNull((Object)message);
        this.details = (String)Preconditions.checkNotNull((Object)details);
        this.throwables = new ArrayList<Throwable>(Arrays.asList(throwable));
        this.image = this.getIconForSeverity(severity, shell);
        this.setShellStyle(67696);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        dialogArea.setLayoutData((Object)new GridData(768));
        ((GridLayout)dialogArea.getLayout()).numColumns = 2;
        Label imageLabel = new Label(dialogArea, 0);
        this.image.setBackground(imageLabel.getBackground());
        imageLabel.setImage(this.image);
        imageLabel.setLayoutData((Object)new GridData(66));
        Composite textArea = new Composite(dialogArea, 0);
        GridLayout textAreaLayout = new GridLayout(1, false);
        textAreaLayout.verticalSpacing = FontUtils.getFontHeightInPixels(parent.getFont());
        textAreaLayout.marginHeight = 0;
        textAreaLayout.marginWidth = 0;
        textArea.setLayout((Layout)textAreaLayout);
        GridData textAreaLayoutData = new GridData(4, 4, true, true, 1, 1);
        textAreaLayoutData.widthHint = this.convertHorizontalDLUsToPixels(300);
        textArea.setLayoutData((Object)textAreaLayoutData);
        Composite stackLayoutContainer = new Composite(textArea, 0);
        this.stackLayout = new StackLayout();
        stackLayoutContainer.setLayout((Layout)this.stackLayout);
        stackLayoutContainer.setLayoutData((Object)new GridData(1808));
        this.singleErrorContainer = new Composite(stackLayoutContainer, 0);
        GridLayout singleErrorContainerLayout = new GridLayout(1, false);
        singleErrorContainerLayout.marginHeight = 0;
        singleErrorContainerLayout.marginWidth = 0;
        this.singleErrorContainer.setLayout((Layout)singleErrorContainerLayout);
        this.stackLayout.topControl = this.singleErrorContainer;
        this.singleErrorMessageLabel = new Label(this.singleErrorContainer, 64);
        GridData messageLabelGridData = new GridData();
        messageLabelGridData.verticalAlignment = 128;
        messageLabelGridData.grabExcessHorizontalSpace = true;
        this.singleErrorMessageLabel.setLayoutData((Object)messageLabelGridData);
        this.singleErrorMessageLabel.setText(this.message);
        this.singleErrorDetailsLabel = new Label(this.singleErrorContainer, 64);
        GridData detailsLabelGridData = new GridData();
        detailsLabelGridData.verticalAlignment = 128;
        detailsLabelGridData.grabExcessHorizontalSpace = true;
        this.singleErrorDetailsLabel.setLayoutData((Object)detailsLabelGridData);
        this.singleErrorDetailsLabel.setText(this.details);
        this.multiErrorContainer = new Composite(stackLayoutContainer, 0);
        GridLayout multiErrorContainerLayout = new GridLayout(1, false);
        multiErrorContainerLayout.marginHeight = 0;
        multiErrorContainerLayout.marginWidth = 0;
        this.multiErrorContainer.setLayout((Layout)multiErrorContainerLayout);
        this.multiErrorMessageLabel = new Label(this.multiErrorContainer, 64);
        this.multiErrorMessageLabel.setLayoutData((Object)new GridData(4, 128, true, false));
        this.multiErrorMessageLabel.setText(this.message);
        GridData multiErrorExceptionListGridData = new GridData();
        multiErrorExceptionListGridData.horizontalAlignment = 4;
        multiErrorExceptionListGridData.verticalAlignment = 4;
        multiErrorExceptionListGridData.grabExcessHorizontalSpace = true;
        multiErrorExceptionListGridData.grabExcessVerticalSpace = true;
        multiErrorExceptionListGridData.widthHint = 800;
        this.exceptionsViewer = new TableViewer(this.multiErrorContainer, 2);
        this.exceptionsViewer.getControl().setLayoutData((Object)multiErrorExceptionListGridData);
        this.exceptionsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.exceptionsViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof Throwable) {
                    return ((Throwable)element).getMessage();
                }
                return "";
            }
        });
        this.exceptionsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ExceptionDetailsDialog.this.updateStacktraceArea();
            }
        });
        this.clipboard = new Clipboard(this.getShell().getDisplay());
        this.updateDisplayedExceptions();
        return dialogArea;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        Button copyExceptionButton = this.createButton(parent, 25, "", false);
        copyExceptionButton.setToolTipText(UiMessages.Button_CopyFailuresToClipboard_Tooltip);
        copyExceptionButton.setImage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_COPY"));
        this.detailsButton = this.createButton(parent, 13, IDialogConstants.SHOW_DETAILS_LABEL, false);
        Button okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        okButton.setFocus();
    }

    protected void setButtonLayoutData(Button button) {
        if (button.getData() != null && button.getData().equals(25)) {
            GridDataFactory.swtDefaults().applyTo((Control)button);
            return;
        }
        super.setButtonLayoutData(button);
    }

    protected void initializeBounds() {
        Composite buttonBar = (Composite)this.getButtonBar();
        GridLayout layout = (GridLayout)buttonBar.getLayout();
        layout.makeColumnsEqualWidth = false;
        super.initializeBounds();
    }

    protected void buttonPressed(int id) {
        if (id == 13) {
            this.toggleStacktraceArea();
        } else if (id == 25) {
            this.copyStacktracesToClipboard();
        } else {
            super.buttonPressed(id);
        }
    }

    public boolean close() {
        if (this.clipboard != null) {
            this.clipboard.dispose();
            this.clipboard = null;
        }
        return super.close();
    }

    private Image getIconForSeverity(int severity, Shell shell) {
        int swtImageKey;
        switch (severity) {
            case 0: 
            case 1: {
                swtImageKey = 2;
                break;
            }
            case 2: 
            case 8: {
                swtImageKey = 8;
                break;
            }
            case 4: {
                swtImageKey = 1;
                break;
            }
            default: {
                swtImageKey = 8;
                UiPlugin.logger().warn("Can't find image for severity: " + severity);
            }
        }
        return shell.getDisplay().getSystemImage(swtImageKey);
    }

    public void addException(Throwable throwable) {
        Throwable exception = throwable;
        this.throwables.add(exception);
        if (this.getContents() != null) {
            this.updateDisplayedExceptions();
        }
    }

    private void updateDisplayedExceptions() {
        this.setExceptionsViewerInput(this.throwables);
        if (this.throwables.size() > 1) {
            this.setDialogTitle(UiMessages.Dialog_Title_Multiple_Errors);
            this.showMultiError();
        } else {
            this.setDialogTitle(this.title);
            this.showSingleError();
        }
    }

    private void toggleStacktraceArea() {
        if (this.isStacktraceAreaVisible()) {
            this.hideStacktraceArea();
        } else {
            this.showStacktraceArea();
            this.updateStacktraceArea();
        }
        this.relayoutShell();
    }

    private void relayoutShell() {
        Point oldSize = this.getContents().getSize();
        Point newSize = this.getContents().computeSize(-1, -1);
        Point oldWindowSize = this.getShell().getSize();
        Point newWindowSize = new Point(oldWindowSize.x, oldWindowSize.y + (newSize.y - oldSize.y));
        Point windowLocation = this.getShell().getLocation();
        Rectangle screenArea = this.getContents().getDisplay().getClientArea();
        if (newWindowSize.y > screenArea.height - (windowLocation.y - screenArea.y)) {
            newWindowSize.y = screenArea.height - (windowLocation.y - screenArea.y);
        }
        this.getShell().setSize(newWindowSize);
        ((Composite)this.getContents()).layout();
    }

    private void updateStacktraceArea() {
        Collection<Throwable> selectedExceptions = this.getSelectedExceptionsFromViewer();
        if (selectedExceptions.isEmpty()) {
            selectedExceptions = this.throwables;
        }
        this.setStacktraceAreaText(this.collectStackTraces(selectedExceptions));
    }

    private boolean isStacktraceAreaVisible() {
        return this.stackTraceAreaControl != null;
    }

    private void showStacktraceArea() {
        this.stackTraceAreaControl = new Composite((Composite)this.getContents(), 0);
        this.stackTraceAreaControl.setLayoutData((Object)new GridData(1808));
        GridLayout containerLayout = new GridLayout();
        containerLayout.marginWidth = 0;
        containerLayout.marginHeight = 0;
        this.stackTraceAreaControl.setLayout((Layout)containerLayout);
        this.stacktraceAreaText = new Text(this.stackTraceAreaControl, 2826);
        this.stacktraceAreaText.setLayoutData((Object)new GridData(1808));
        this.detailsButton.setText(IDialogConstants.HIDE_DETAILS_LABEL);
    }

    private String collectStackTraces(Collection<Throwable> throwables) {
        StringWriter writer = new StringWriter(1024);
        PrintWriter printWriter = new PrintWriter(writer);
        for (Throwable throwable : throwables) {
            throwable.printStackTrace(printWriter);
            printWriter.write(LINE_SEPARATOR);
        }
        return ((Object)writer).toString();
    }

    private void copyStacktracesToClipboard() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.message);
        sb.append(LINE_SEPARATOR);
        sb.append(this.details);
        sb.append(LINE_SEPARATOR);
        sb.append(this.collectStackTraces(this.throwables));
        this.setClipboardContent(sb.toString());
    }

    private void hideStacktraceArea() {
        this.stackTraceAreaControl.dispose();
        this.stackTraceAreaControl = null;
        this.detailsButton.setText(IDialogConstants.SHOW_DETAILS_LABEL);
    }

    private void showSingleError() {
        if (this.stackLayout != null && ExceptionDetailsDialog.isAccessible((Widget)this.singleErrorContainer)) {
            this.stackLayout.topControl = this.singleErrorContainer;
            this.singleErrorContainer.getParent().layout();
        }
    }

    private void showMultiError() {
        if (this.stackLayout != null && ExceptionDetailsDialog.isAccessible((Widget)this.multiErrorContainer)) {
            this.stackLayout.topControl = this.multiErrorContainer;
            this.multiErrorContainer.getParent().layout();
        }
    }

    private Collection<Throwable> getSelectedExceptionsFromViewer() {
        ISelection selection;
        if (ExceptionDetailsDialog.isAccessible((Viewer)this.exceptionsViewer) && (selection = this.exceptionsViewer.getSelection()) instanceof IStructuredSelection) {
            List structuredSelection = ((IStructuredSelection)selection).toList();
            return FluentIterable.from((Iterable)structuredSelection).filter(Throwable.class).toList();
        }
        return Collections.emptyList();
    }

    private void setClipboardContent(String content) {
        if (this.clipboard != null && !this.clipboard.isDisposed()) {
            this.clipboard.setContents((Object[])new String[]{content}, new Transfer[]{TextTransfer.getInstance()});
        }
    }

    private void setExceptionsViewerInput(Collection<Throwable> input) {
        if (ExceptionDetailsDialog.isAccessible((Viewer)this.exceptionsViewer)) {
            this.exceptionsViewer.setInput(input);
        }
    }

    private void setStacktraceAreaText(String text) {
        if (ExceptionDetailsDialog.isAccessible((Widget)this.stacktraceAreaText)) {
            this.stacktraceAreaText.setText(text);
        }
    }

    private void setDialogTitle(String title) {
        Shell control = this.getShell();
        if (ExceptionDetailsDialog.isAccessible((Widget)control)) {
            control.setText(title);
        }
    }

    private static boolean isAccessible(Widget widget) {
        return widget != null && !widget.isDisposed();
    }

    private static boolean isAccessible(Viewer widget) {
        return widget != null && ExceptionDetailsDialog.isAccessible((Widget)widget.getControl());
    }
}

