/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.merrimac.clad;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.bpmn2.modeler.core.Activator;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesProvider;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractBpmn2PropertySection;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractDetailComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.AbstractDialogComposite;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.IPropertiesCompositeFactory;
import org.eclipse.bpmn2.modeler.core.merrimac.clad.PropertiesCompositeFactory;
import org.eclipse.bpmn2.modeler.core.runtime.Bpmn2SectionDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.PropertyTabDescriptor;
import org.eclipse.bpmn2.modeler.core.runtime.TargetRuntime;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptor;
import org.eclipse.ui.views.properties.tabbed.ITabDescriptorProvider;

public class DefaultDialogComposite
extends AbstractDialogComposite {
    protected IPreferenceStore preferenceStore = Activator.getDefault().getPreferenceStore();
    protected EObject businessObject;
    protected List<AbstractDetailComposite> details = new ArrayList<AbstractDetailComposite>();
    protected List<AbstractBpmn2PropertySection> sections = new ArrayList<AbstractBpmn2PropertySection>();
    protected TabFolder folder;
    protected Composite control;
    protected ITabDescriptor[] tabDescriptors;
    protected AbstractBpmn2PropertySection section;
    private IPropertiesCompositeFactory compositeFactory = null;

    public DefaultDialogComposite(Composite parent, EClass eclass, int style) {
        super(parent, eclass, style);
    }

    protected void init() {
        Composite parent = this.getParent();
        this.setLayout((Layout)new FormLayout());
        TargetRuntime rt = TargetRuntime.getRuntime(this.businessObject);
        if (this.compositeFactory != null) {
            this.control = this.compositeFactory.createDetailComposite(this.eclass.getInstanceClass(), this, rt, 0);
        } else {
            ITabDescriptor[] tabDescriptors = this.getTabDescriptors();
            int detailsCount = this.getDetailsCount();
            if (detailsCount > 0) {
                this.folder = new TabFolder((Composite)this, 0);
                this.folder.setLayout((Layout)new FormLayout());
                this.folder.setBackground(parent.getBackground());
                ITabDescriptor[] iTabDescriptorArray = tabDescriptors;
                int n = tabDescriptors.length;
                int n2 = 0;
                while (n2 < n) {
                    ITabDescriptor td = iTabDescriptorArray[n2];
                    for (Object o : td.getSectionDescriptors()) {
                        if (!(o instanceof Bpmn2SectionDescriptor)) continue;
                        Bpmn2SectionDescriptor sd = (Bpmn2SectionDescriptor)((Object)o);
                        TabItem tab = new TabItem(this.folder, 0);
                        ScrolledForm form = new ScrolledForm((Composite)this.folder, 512);
                        form.setBackground(parent.getBackground());
                        FormData data = new FormData();
                        data.top = new FormAttachment(0, 0);
                        data.bottom = new FormAttachment(100, 0);
                        data.left = new FormAttachment(0, 0);
                        data.right = new FormAttachment(100, 0);
                        form.setLayoutData((Object)data);
                        form.setExpandVertical(true);
                        form.setExpandHorizontal(true);
                        form.setBackground(parent.getBackground());
                        Composite body = form.getBody();
                        TableWrapLayout tableWrapLayout = new TableWrapLayout();
                        tableWrapLayout.numColumns = 1;
                        tableWrapLayout.verticalSpacing = 1;
                        tableWrapLayout.horizontalSpacing = 1;
                        TableWrapData twd = new TableWrapData(256);
                        body.setLayout((Layout)tableWrapLayout);
                        body.setLayoutData((Object)twd);
                        this.section = (AbstractBpmn2PropertySection)sd.getSectionClass();
                        AbstractDetailComposite detail = this.getDetail(this.section, body);
                        detail.setLayoutData(new TableWrapData(256));
                        form.setContent((Control)body);
                        String label = td.getLabel();
                        if (label == null) {
                            label = ExtendedPropertiesProvider.getLabel(this.businessObject);
                        }
                        tab.setText(label);
                        tab.setControl((Control)form);
                        this.details.add(detail);
                        this.sections.add(this.section);
                    }
                    ++n2;
                }
                this.control = this.folder;
                this.control.setBackground(parent.getBackground());
            } else if (this.section != null) {
                this.control = this.section.createSectionRoot(this, 0);
            }
        }
        if (this.control == null) {
            this.control = PropertiesCompositeFactory.INSTANCE.createDetailComposite(this.eclass.getInstanceClass(), this, rt, 0);
        }
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        this.control.setLayoutData((Object)data);
        this.layout(true);
    }

    protected ITabDescriptor[] getTabDescriptors() {
        if (this.tabDescriptors == null) {
            IWorkbenchPart part = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getPartService().getActivePart();
            part.getAdapter(ITabDescriptorProvider.class);
            Object selection = this.businessObject == null ? PlatformUI.getWorkbench().getActiveWorkbenchWindow().getSelectionService().getSelection() : new StructuredSelection((Object)this.businessObject);
            ITabDescriptorProvider tabDescriptorProvider = (ITabDescriptorProvider)part.getAdapter(ITabDescriptorProvider.class);
            ArrayList<ITabDescriptor> list = new ArrayList<ITabDescriptor>();
            ITabDescriptor[] iTabDescriptorArray = tabDescriptorProvider.getTabDescriptors(part, selection);
            int n = iTabDescriptorArray.length;
            int n2 = 0;
            while (n2 < n) {
                ITabDescriptor td = iTabDescriptorArray[n2];
                if (!(td instanceof PropertyTabDescriptor) || ((PropertyTabDescriptor)td).isPopup()) {
                    list.add(td);
                }
                ++n2;
            }
            this.tabDescriptors = list.toArray(new ITabDescriptor[list.size()]);
        }
        return this.tabDescriptors;
    }

    protected int getDetailsCount() {
        ITabDescriptor[] tabDescriptors;
        int detailsCount = 0;
        ITabDescriptor[] iTabDescriptorArray = tabDescriptors = this.getTabDescriptors();
        int n = tabDescriptors.length;
        int n2 = 0;
        while (n2 < n) {
            ITabDescriptor td = iTabDescriptorArray[n2];
            if (!(td instanceof PropertyTabDescriptor) || ((PropertyTabDescriptor)td).isPopup()) {
                for (Object o : td.getSectionDescriptors()) {
                    if (!(o instanceof Bpmn2SectionDescriptor)) continue;
                    Bpmn2SectionDescriptor sd = (Bpmn2SectionDescriptor)((Object)o);
                    this.section = (AbstractBpmn2PropertySection)sd.getSectionClass();
                    ++detailsCount;
                }
            }
            ++n2;
        }
        return detailsCount;
    }

    protected AbstractDetailComposite getDetail(AbstractBpmn2PropertySection section, Composite parent) {
        return section.createSectionRoot(parent, 0);
    }

    public void setData(String key, Object object) {
        if ("factory".equals(key) && object instanceof IPropertiesCompositeFactory) {
            this.compositeFactory = (IPropertiesCompositeFactory)object;
        }
        super.setData(key, object);
    }

    public void setData(Object object) {
        int i;
        this.businessObject = (EObject)object;
        this.init();
        if (this.details != null && this.details.size() > 0) {
            i = 0;
            while (i < this.details.size()) {
                AbstractDetailComposite detail = this.details.get(i);
                AbstractBpmn2PropertySection section = this.sections.get(i);
                detail.setIsPopupDialog(true);
                StructuredSelection selection = new StructuredSelection((Object)this.businessObject);
                EObject bo = section.getBusinessObjectForSelection((ISelection)selection);
                Object data = this.getData("container");
                if (data != null) {
                    detail.setData("container", data);
                }
                detail.setBusinessObject(bo);
                ++i;
            }
        } else if (this.control instanceof AbstractDetailComposite) {
            ((AbstractDetailComposite)this.control).setIsPopupDialog(true);
            ((AbstractDetailComposite)this.control).setBusinessObject(this.businessObject);
        }
        if (this.folder != null) {
            i = this.preferenceStore.getInt("dialog." + this.eclass.getName() + ".tab");
            if (i >= 0 && i < this.folder.getItemCount()) {
                this.folder.setSelection(i);
            }
            this.folder.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int i = DefaultDialogComposite.this.folder.getSelectionIndex();
                    DefaultDialogComposite.this.preferenceStore.setValue("dialog." + DefaultDialogComposite.this.eclass.getName() + ".tab", i);
                }
            });
            if (this.details != null) {
                ArrayList<TabItem> removedTabs = new ArrayList<TabItem>();
                ArrayList<AbstractDetailComposite> removedDetails = new ArrayList<AbstractDetailComposite>();
                i = 0;
                while (i < this.details.size()) {
                    AbstractDetailComposite detail = this.details.get(i);
                    if (detail.isEmpty()) {
                        removedTabs.add(this.folder.getItem(i));
                        removedDetails.add(detail);
                    }
                    ++i;
                }
                for (TabItem tab : removedTabs) {
                    tab.dispose();
                }
                this.details.removeAll(removedDetails);
            }
        }
    }

    public void dispose() {
        if (this.details != null) {
            for (AbstractDetailComposite detail : this.details) {
                detail.dispose();
            }
        }
        this.control.dispose();
        super.dispose();
    }
}

