/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bpmn2.modeler.core.adapters;

import java.util.Hashtable;
import java.util.Map;
import org.eclipse.bpmn2.modeler.core.adapters.AdapterUtil;
import org.eclipse.bpmn2.modeler.core.adapters.ExtendedPropertiesAdapter;
import org.eclipse.bpmn2.modeler.core.adapters.Messages;
import org.eclipse.bpmn2.modeler.core.model.Bpmn2ModelerFactory;
import org.eclipse.bpmn2.modeler.core.model.ModelDecorator;
import org.eclipse.bpmn2.modeler.core.utils.ModelUtil;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.osgi.util.NLS;

public class ObjectDescriptor<T extends EObject> {
    protected T object;
    protected String label;
    protected String textValue;
    protected ExtendedPropertiesAdapter<T> owner;
    protected Hashtable<String, Object> properties = null;

    public ObjectDescriptor(ExtendedPropertiesAdapter<T> owner, T object) {
        this.owner = owner;
        this.object = object;
    }

    public ExtendedPropertiesAdapter<T> getOwner() {
        return this.owner;
    }

    public void setOwner(ExtendedPropertiesAdapter<T> owner) {
        this.owner = owner;
    }

    public T getObject() {
        return this.object;
    }

    public void setObject(T object) {
        this.object = object;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        String s = ModelDecorator.getLabel((EModelElement)this.object.eClass());
        if (s != null) {
            return s;
        }
        if (this.label == null) {
            EClass eclass = this.object instanceof EClass ? (EClass)this.object : this.object.eClass();
            this.label = ModelUtil.toCanonicalString(eclass.getName());
        }
        return this.label;
    }

    public void setTextValue(String textValue) {
        this.textValue = textValue;
    }

    public String getTextValue() {
        if (this.textValue == null) {
            String text = ModelUtil.toCanonicalString(this.object.eClass().getName());
            Object value = null;
            EStructuralFeature f = null;
            f = this.object.eClass().getEStructuralFeature("name");
            if (f == null) {
                f = ModelDecorator.getAnyAttribute(this.object, "name");
            }
            if (f != null && ((value = this.object.eGet(f)) == null || value.toString().isEmpty())) {
                value = null;
            }
            if (value == null && (f = this.object.eClass().getEStructuralFeature("id")) != null && ((value = this.object.eGet(f)) == null || value.toString().isEmpty())) {
                value = null;
            }
            if (value == null) {
                value = NLS.bind((String)Messages.ObjectDescriptor_Unnamed, (Object)text);
            }
            return (String)value;
        }
        return this.textValue;
    }

    protected IItemPropertyDescriptor getPropertyDescriptor(EStructuralFeature feature) {
        return this.getPropertyDescriptor(this.object, feature);
    }

    protected IItemPropertyDescriptor getPropertyDescriptor(T object, EStructuralFeature feature) {
        ItemProviderAdapter adapter = null;
        for (Adapter a : object.eAdapters()) {
            if (!(a instanceof ItemProviderAdapter)) continue;
            adapter = (ItemProviderAdapter)a;
            break;
        }
        if (adapter != null) {
            return adapter.getPropertyDescriptor(object, (Object)feature);
        }
        return null;
    }

    public boolean equals(Object otherObject) {
        T thisObject = this.object;
        if (otherObject instanceof EObject) {
            return ExtendedPropertiesAdapter.compare(thisObject, (EObject)otherObject, false);
        }
        return super.equals(otherObject);
    }

    public boolean similar(Object other) {
        T thisObject = this.object;
        if (other instanceof EObject) {
            return ExtendedPropertiesAdapter.compare(thisObject, (EObject)other, true);
        }
        return super.equals(other);
    }

    protected boolean compare(EObject other, boolean similar) {
        return ExtendedPropertiesAdapter.compare(this.object, other, similar);
    }

    protected T adopt(Object context) {
        Object result = this.object.getClass().isInstance(context) ? (EObject)context : this.object;
        return (T)result;
    }

    public TransactionalEditingDomain getEditingDomain(EObject context) {
        T object = this.adopt(context);
        EditingDomain result = AdapterFactoryEditingDomain.getEditingDomainFor(object);
        if (result == null) {
            if (object instanceof IEditingDomainProvider) {
                result = ((IEditingDomainProvider)object).getEditingDomain();
            }
            if (result == null) {
                IEditingDomainProvider provider = AdapterUtil.adapt(object, IEditingDomainProvider.class);
                if (provider != null) {
                    result = provider.getEditingDomain();
                }
                if (result == null) {
                    result = this.owner.getEditingDomain();
                }
            }
        }
        if (result instanceof TransactionalEditingDomain) {
            return (TransactionalEditingDomain)result;
        }
        return null;
    }

    public Resource getResource() {
        return this.owner.getResource();
    }

    public T createObject(Resource resource, EClass eclass, Map<String, Object> args) {
        EClass eClass = null;
        eClass = eclass instanceof EClass ? eclass : (eclass instanceof EObject ? eclass.eClass() : this.object.eClass());
        Assert.isTrue((boolean)this.object.eClass().isSuperTypeOf(eClass));
        if (resource == null) {
            resource = this.getResource();
        }
        EObject newObject = Bpmn2ModelerFactory.create(resource, eClass, args);
        return (T)newObject;
    }

    public void setProperty(String key, Object value) {
        if (value == null) {
            if (this.properties != null) {
                this.properties.remove(key);
                if (this.properties.isEmpty()) {
                    this.properties = null;
                }
            }
        } else {
            if (this.properties == null) {
                this.properties = new Hashtable();
            }
            this.properties.put(key, value);
        }
    }

    public Object getProperty(String key) {
        if (this.properties == null) {
            return null;
        }
        return this.properties.get(key);
    }
}

