/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.InfixExpression;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.ParenthesizedExpression;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.StringLiteral;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.fix.CompilationUnitRewriteOperationsFixCore;
import org.eclipse.jdt.internal.corext.fix.LinkedProposalModelCore;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFix;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;
import org.eclipse.text.edits.TextEditGroup;

public class NoStringCreationCleanUpCore
extends AbstractMultiFix {
    public NoStringCreationCleanUpCore() {
        this(Collections.emptyMap());
    }

    public NoStringCreationCleanUpCore(Map<String, String> options) {
        super(options);
    }

    @Override
    public CleanUpRequirements getRequirements() {
        boolean requireAST = this.isEnabled("cleanup.no_string_creation");
        return new CleanUpRequirements(requireAST, false, false, null);
    }

    @Override
    public String[] getStepDescriptions() {
        if (this.isEnabled("cleanup.no_string_creation")) {
            return new String[]{MultiFixMessages.NoStringCreationCleanUp_description};
        }
        return new String[0];
    }

    @Override
    public String getPreview() {
        if (this.isEnabled("cleanup.no_string_creation")) {
            return "String bar = \"foo\";\nString newBar = bar.concat(\"abc\");\nString cantChange = new String(possibleNullObject)\n";
        }
        return "String bar = new String(\"foo\");\nString newBar = (new String(bar)).concat(\"abc\");\nString cantChange = new String(possibleNullObject)\n";
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit) throws CoreException {
        if (!this.isEnabled("cleanup.no_string_creation")) {
            return null;
        }
        final ArrayList rewriteOperations = new ArrayList();
        unit.accept(new ASTVisitor(){

            public boolean visit(ClassInstanceCreation node) {
                if (ASTNodes.hasType((Expression)node, String.class.getCanonicalName()) && node.arguments().size() == 1) {
                    ClassInstanceCreation c;
                    Expression arg0 = ASTNodes.getUnparenthesedExpression((Expression)node.arguments().get(0));
                    while (arg0 instanceof ClassInstanceCreation && ASTNodes.hasType((Expression)(c = (ClassInstanceCreation)arg0), String.class.getCanonicalName()) && c.arguments().size() == 1) {
                        arg0 = ASTNodes.getUnparenthesedExpression((Expression)c.arguments().get(0));
                    }
                    if (ASTNodes.hasType(arg0, String.class.getCanonicalName())) {
                        if (arg0 instanceof StringLiteral || arg0 instanceof InfixExpression) {
                            rewriteOperations.add(new NoStringCreationOperation(node, arg0));
                            return false;
                        }
                        if (arg0 instanceof MethodInvocation || arg0 instanceof SimpleName) {
                            ASTNode parent = node.getParent();
                            while (parent instanceof ParenthesizedExpression) {
                                parent = parent.getParent();
                            }
                            if (parent instanceof Assignment || parent instanceof VariableDeclarationFragment) {
                                return true;
                            }
                            if (parent instanceof MethodInvocation || parent instanceof FieldAccess) {
                                rewriteOperations.add(new NoStringCreationOperation(node, arg0));
                            }
                            return false;
                        }
                    }
                }
                return true;
            }
        });
        if (rewriteOperations.isEmpty()) {
            return null;
        }
        return new CompilationUnitRewriteOperationsFixCore(MultiFixMessages.NoStringCreationCleanUp_description, unit, rewriteOperations.toArray(new CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation[0]));
    }

    @Override
    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocation problem) {
        return false;
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit unit, IProblemLocation[] problems) throws CoreException {
        return null;
    }

    private static class NoStringCreationOperation
    extends CompilationUnitRewriteOperationsFixCore.CompilationUnitRewriteOperation {
        private final ClassInstanceCreation node;
        private final Expression arg0;

        public NoStringCreationOperation(ClassInstanceCreation node, Expression arg0) {
            this.node = node;
            this.arg0 = arg0;
        }

        @Override
        public void rewriteAST(CompilationUnitRewrite cuRewrite, LinkedProposalModelCore linkedModel) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = cuRewrite.getRoot().getAST();
            TextEditGroup group = this.createTextEditGroup(MultiFixMessages.NoStringCreationCleanUp_description, cuRewrite);
            Expression replacement = ASTNodeFactory.parenthesizeIfNeeded(ast, ASTNodes.createMoveTarget(rewrite, this.arg0));
            ClassInstanceCreation nodeToReplace = this.node;
            while (nodeToReplace.getParent() instanceof ParenthesizedExpression) {
                nodeToReplace = nodeToReplace.getParent();
            }
            ASTNodes.replaceButKeepComment(rewrite, (ASTNode)nodeToReplace, (ASTNode)replacement, group);
        }
    }
}

