/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.internal.core.manipulation.JavaElementLabelsCore;
import org.eclipse.jdt.internal.corext.CorextCore;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaStatusContext;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.jdt.internal.ui.util.Progress;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;

public class MethodChecks {
    private MethodChecks() {
    }

    public static boolean isVirtual(IMethod method) throws JavaModelException {
        if (method.isConstructor()) {
            return false;
        }
        if (JdtFlags.isPrivate((IMember)method)) {
            return false;
        }
        return !JdtFlags.isStatic((IMember)method);
    }

    public static boolean isVirtual(IMethodBinding methodBinding) {
        if (methodBinding.isConstructor()) {
            return false;
        }
        if (Modifier.isPrivate((int)methodBinding.getModifiers())) {
            return false;
        }
        return !Modifier.isStatic((int)methodBinding.getModifiers());
    }

    public static RefactoringStatus checkIfOverridesAnother(IMethod method, ITypeHierarchy hierarchy) throws JavaModelException {
        IMethod overrides = MethodChecks.overridesAnotherMethod(method, hierarchy);
        if (overrides == null) {
            return null;
        }
        RefactoringStatusContext context = JavaStatusContext.create((IMember)overrides);
        String message = Messages.format(RefactoringCoreMessages.MethodChecks_overrides, new String[]{JavaElementUtil.createMethodSignature(overrides), JavaElementLabelsCore.getElementLabel((IJavaElement)overrides.getDeclaringType(), 2235681801344L)});
        return RefactoringStatus.createStatus((int)4, (String)message, (RefactoringStatusContext)context, (String)CorextCore.getPluginId(), (int)1, (Object)overrides);
    }

    public static RefactoringStatus checkIfComesFromInterface(IMethod method, ITypeHierarchy hierarchy, IProgressMonitor monitor) throws JavaModelException {
        IMethod inInterface = MethodChecks.isDeclaredInInterface(method, hierarchy, monitor);
        if (inInterface == null) {
            return null;
        }
        RefactoringStatusContext context = JavaStatusContext.create((IMember)inInterface);
        String message = Messages.format(RefactoringCoreMessages.MethodChecks_implements, new String[]{JavaElementUtil.createMethodSignature(inInterface), JavaElementLabelsCore.getElementLabel((IJavaElement)inInterface.getDeclaringType(), 2235681801344L)});
        return RefactoringStatus.createStatus((int)4, (String)message, (RefactoringStatusContext)context, (String)CorextCore.getPluginId(), (int)2, (Object)inInterface);
    }

    public static IMethod isDeclaredInInterface(IMethod method, ITypeHierarchy hierarchy, IProgressMonitor monitor) throws JavaModelException {
        Assert.isTrue((boolean)MethodChecks.isVirtual(method));
        IProgressMonitor subMonitor = Progress.subMonitor(monitor, 1);
        try {
            IType[] classes = hierarchy.getAllClasses();
            subMonitor.beginTask("", classes.length);
            IType[] iTypeArray = classes;
            int n = classes.length;
            int n2 = 0;
            while (n2 < n) {
                IType clazz = iTypeArray[n2];
                IType[] superinterfaces = null;
                superinterfaces = clazz.equals(hierarchy.getType()) ? hierarchy.getAllSuperInterfaces(clazz) : clazz.newSupertypeHierarchy(Progress.subMonitor(subMonitor, 1)).getAllSuperInterfaces(clazz);
                IType[] iTypeArray2 = superinterfaces;
                int n3 = superinterfaces.length;
                int n4 = 0;
                while (n4 < n3) {
                    IType superinterface = iTypeArray2[n4];
                    IMethod found = Checks.findSimilarMethod(method, superinterface);
                    if (found != null && !found.equals(method)) {
                        IMethod iMethod = found;
                        return iMethod;
                    }
                    ++n4;
                }
                subMonitor.worked(1);
                ++n2;
            }
            return null;
        }
        finally {
            subMonitor.done();
        }
    }

    public static IMethod overridesAnotherMethod(IMethod method, ITypeHierarchy hierarchy) throws JavaModelException {
        boolean overrides;
        MethodOverrideTester tester = new MethodOverrideTester(method.getDeclaringType(), hierarchy);
        IMethod found = tester.findDeclaringMethod(method, true);
        boolean bl = overrides = found != null && !found.equals(method) && !JdtFlags.isStatic((IMember)found) && !JdtFlags.isPrivate((IMember)found);
        if (overrides) {
            return found;
        }
        return null;
    }

    public static IMethod getTopmostMethod(IMethod method, ITypeHierarchy typeHierarchy, IProgressMonitor monitor) throws JavaModelException {
        Assert.isNotNull((Object)method);
        ITypeHierarchy hierarchy = typeHierarchy;
        IMethod topmostMethod = null;
        IType declaringType = method.getDeclaringType();
        if (!declaringType.isInterface()) {
            IMethod inInterface;
            if (hierarchy == null || !declaringType.equals(hierarchy.getType())) {
                hierarchy = declaringType.newTypeHierarchy(monitor);
            }
            if ((inInterface = MethodChecks.isDeclaredInInterface(method, hierarchy, monitor)) != null && !inInterface.equals(method)) {
                topmostMethod = inInterface;
            }
        }
        if (topmostMethod == null) {
            IMethod overrides;
            if (hierarchy == null) {
                hierarchy = declaringType.newSupertypeHierarchy(monitor);
            }
            if ((overrides = MethodChecks.overridesAnotherMethod(method, hierarchy)) != null && !overrides.equals(method)) {
                topmostMethod = overrides;
            }
        }
        return topmostMethod;
    }
}

