/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ExpressionVariableType implements Enumerator
{
    RESULT_SET_COLUMN(0, "ResultSetColumn", "ResultSetColumn"),
    INSTANCE_OF(1, "InstanceOf", "InstanceOf"),
    QUERY_EXPRESSION(2, "QueryExpression", "QueryExpression");

    public static final String copyright = "Copyright (c) 2009 Actuate Corporation";
    public static final int RESULT_SET_COLUMN_VALUE = 0;
    public static final int INSTANCE_OF_VALUE = 1;
    public static final int QUERY_EXPRESSION_VALUE = 2;
    private static final ExpressionVariableType[] VALUES_ARRAY;
    public static final List<ExpressionVariableType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new ExpressionVariableType[]{RESULT_SET_COLUMN, INSTANCE_OF, QUERY_EXPRESSION};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static ExpressionVariableType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ExpressionVariableType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ExpressionVariableType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ExpressionVariableType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ExpressionVariableType get(int value) {
        switch (value) {
            case 0: {
                return RESULT_SET_COLUMN;
            }
            case 1: {
                return INSTANCE_OF;
            }
            case 2: {
                return QUERY_EXPRESSION;
            }
        }
        return null;
    }

    private ExpressionVariableType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

