/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.oda.design.internal.ui.profile;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import org.eclipse.core.runtime.Path;
import org.eclipse.datatools.connectivity.ICategory;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.ResourceIdentifiers;
import org.eclipse.datatools.connectivity.oda.design.internal.designsession.DataSourceDesignSessionBase;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.CreateProfileStoreAction;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.ProfileSelection;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.ProfileSelectionEditorPage;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.ProfileSelectionWizardPage;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.ProfileStoreCreationDialog;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.browse.IBrowseButtonHost;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.browse.MenuButtonProvider;
import org.eclipse.datatools.connectivity.oda.design.internal.ui.profile.browse.ProfileStoreBrowseButton;
import org.eclipse.datatools.connectivity.oda.design.ui.nls.Messages;
import org.eclipse.datatools.connectivity.oda.design.ui.nls.TextProcessorWrapper;
import org.eclipse.datatools.connectivity.oda.design.util.DesignUtil;
import org.eclipse.datatools.connectivity.oda.profile.OdaProfileExplorer;
import org.eclipse.datatools.connectivity.oda.profile.internal.ProfileCategoryUtil;
import org.eclipse.datatools.connectivity.oda.util.manifest.ExtensionManifest;
import org.eclipse.datatools.connectivity.oda.util.manifest.ManifestExplorer;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;

class ProfileSelectionPageHelper
implements IBrowseButtonHost {
    private static final String EMPTY_STRING = "";
    private static final String CONTEXT_ID_CONNECTIONPROFILE = "org.eclipse.datatools.oda.cshelp.Wizard_ConnectionProfile_ID";
    private static final String DISABLE_AUTO_SELECT_ITEM = "DisableAutoSelect";
    private static final int TREE_ITEM_STYLE = 0;
    private static final int BUTTON_MIN_WIDTH = 80;
    private WizardPage m_wizardPage;
    private PreferencePage m_propertyPage;
    private transient Label m_dataSourceNameLabel = null;
    private transient Text m_connectionProfilePath = null;
    private transient Text m_dataSourceDesignNameControl = null;
    private transient Button m_linkRefCheckBox = null;
    private transient String m_profileID;
    private transient String m_odaDataSourceID;
    private transient Button m_useDefaultDSNameCheckBox = null;
    private transient ProfileStoreBrowseButton m_browseButton = null;
    private transient Tree m_odaDataSourceTree = null;
    private transient String m_treeFilter;
    private transient SortedSet<OdaProfileCategoryInfo> m_dataSourceIDs = null;
    private transient DataSourceDesignSessionBase.IDesignNameValidatorBase m_designNameValidator;
    private transient HashMap<String, String> m_deprecatedDataSourceMap = new HashMap();
    private String m_dataSourceDesignName = "";
    private ResourceIdentifiers m_hostResourceIdentifiers = null;

    ProfileSelectionPageHelper(WizardPage page) {
        this.m_wizardPage = page;
    }

    ProfileSelectionPageHelper(PropertyPage page) {
        this.m_propertyPage = page;
    }

    Control createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        container.setLayout((Layout)layout);
        this.setupConnectionProfilePath(container);
        this.setupLinkCheckBox(container);
        this.setupTreeViewer(container);
        this.setupDataSourceName(container);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)container, CONTEXT_ID_CONNECTIONPROFILE);
        return container;
    }

    void initControl(ProfileSelection selectedProfile) {
        if (selectedProfile == null) {
            return;
        }
        this.m_treeFilter = selectedProfile.getOdaDataSourceId();
        boolean hasInvalidProfileRef = false;
        DataSourceDesignSessionBase.ProfileReferenceBase profileRef = selectedProfile.getProfileRef();
        if (profileRef != null) {
            String profileStorePath = profileRef.getStorageFilePathPropertyValue();
            if (profileStorePath != null) {
                this.setConnProfilePathControlText(profileStorePath, true);
                TreeItem profileItem = this.findProfileInTree(selectedProfile.getOdaDataSourceId(), profileRef.getInstanceId());
                if (profileItem != null) {
                    assert (this.m_odaDataSourceTree != null);
                    this.m_odaDataSourceTree.setSelection(profileItem);
                    this.m_odaDataSourceTree.showSelection();
                    this.m_useDefaultDSNameCheckBox.setSelection(profileItem.getText().equals(selectedProfile.getDataSourceDesignName()));
                    this.m_profileID = profileItem.getData().toString();
                    this.m_odaDataSourceID = this.getProfileItemDataSourceId(profileItem);
                    this.setExternalLinkOption(this.m_odaDataSourceID);
                    this.setPageComplete(true);
                } else {
                    hasInvalidProfileRef = true;
                }
            }
            this.m_linkRefCheckBox.setSelection(profileRef.maintainExternalLink());
        }
        this.m_dataSourceDesignName = selectedProfile.getDataSourceDesignName();
        this.m_dataSourceDesignNameControl.setText(this.m_dataSourceDesignName);
        if (this.inEditMode()) {
            this.setDataSourceNameEditorVisible(false);
            if (profileRef != null && hasInvalidProfileRef) {
                String errorMessage = profileRef.getStorageFile() == null ? Messages.profilePage_error_invalidProfileStorePath : Messages.bind((String)Messages.designSession_invalidProfileName, (Object)profileRef.getName());
                this.setMessage(errorMessage, 3);
            }
        }
    }

    void setDesignNameValidator(DataSourceDesignSessionBase.IDesignNameValidatorBase validator) {
        this.m_designNameValidator = validator;
    }

    ProfileSelection collectProfileSelection() {
        if (!this.hasSelectedProfile() || !this.isPageComplete()) {
            return null;
        }
        String profileStorePathText = this.getConnProfilePathControlText();
        String resolvedProfileStorePath = this.resolveProfileStorePath(profileStorePathText);
        boolean isProfileStorePathRelative = false;
        if (resolvedProfileStorePath != null && !resolvedProfileStorePath.equals(profileStorePathText)) {
            isProfileStorePathRelative = true;
        }
        File profileStoreFile = new Path(resolvedProfileStorePath).toFile();
        return new ProfileSelection(this.m_odaDataSourceID, this.m_dataSourceDesignName, new DataSourceDesignSessionBase.ProfileReferenceBase(this.m_profileID, profileStoreFile, this.m_linkRefCheckBox.getSelection(), DesignUtil.convertFileToResourcePath((File)profileStoreFile, (ResourceIdentifiers)this.m_hostResourceIdentifiers, (boolean)isProfileStorePathRelative)));
    }

    private boolean isPageComplete() {
        boolean isPageComplete = true;
        if (this.m_wizardPage != null) {
            isPageComplete = this.m_wizardPage.isPageComplete();
        } else if (this.m_propertyPage != null) {
            isPageComplete = this.m_propertyPage.isValid();
        } else {
            boolean bl = isPageComplete = this.getMessageType() != 3;
        }
        if (!isPageComplete) {
            return isPageComplete;
        }
        if (this.m_linkRefCheckBox != null && this.m_linkRefCheckBox.getSelection()) {
            isPageComplete = this.hasSelectedProfile();
        }
        return isPageComplete;
    }

    private void setPageComplete(boolean complete) {
        if (this.m_wizardPage != null) {
            this.m_wizardPage.setPageComplete(complete);
        } else if (this.m_propertyPage != null) {
            this.m_propertyPage.setValid(complete);
        }
        if (complete) {
            this.setMessage(EMPTY_STRING, 0);
        } else {
            this.setDefaultMessageAsError(true);
        }
    }

    private void setMessage(String newMessage, int newType) {
        if (this.m_wizardPage != null) {
            this.m_wizardPage.setMessage(newMessage, newType);
        } else if (this.m_propertyPage != null) {
            if (newMessage.length() == 0 && newType == 0) {
                newMessage = Messages.profilePage_pageTitle;
            }
            this.m_propertyPage.setMessage(newMessage, newType);
        }
    }

    private void setDefaultMessageAsError(boolean isError) {
        int newType = isError ? 3 : 0;
        this.setMessage(Messages.profilePage_selectProfileDefaultMessage, newType);
    }

    int getMessageType() {
        if (this.m_wizardPage != null) {
            return this.m_wizardPage.getMessageType();
        }
        if (this.m_propertyPage != null) {
            return this.m_propertyPage.getMessageType();
        }
        return 0;
    }

    private Shell getShell() {
        if (this.m_wizardPage != null) {
            return this.m_wizardPage.getShell();
        }
        assert (this.m_propertyPage != null);
        return this.m_propertyPage.getShell();
    }

    private void setupConnectionProfilePath(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(Messages.profilePage_label_profileStore);
        label.setLayoutData((Object)new GridData(32));
        this.m_connectionProfilePath = new Text(composite, 2048);
        GridData layoutData = new GridData(768);
        layoutData.widthHint = 260;
        this.m_connectionProfilePath.setLayoutData((Object)layoutData);
        this.m_connectionProfilePath.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BusyIndicator.showWhile((Display)(ProfileSelectionPageHelper.this.getShell() == null ? null : ProfileSelectionPageHelper.this.getShell().getDisplay()), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        TreeItem singleProfileItem;
                        ProfileSelectionPageHelper.this.populateTree();
                        ProfileSelectionPageHelper.this.setExternalLinkDefaultState();
                        ProfileSelectionPageHelper.this.clearSelectedProfile();
                        ProfileSelectionPageHelper.this.setSelectedDataSourceName(ProfileSelectionPageHelper.EMPTY_STRING);
                        ProfileSelectionPageHelper.this.setDefaultMessageAsError(ProfileSelectionPageHelper.this.hasConnectionProfilePath());
                        if (ProfileSelectionPageHelper.this.hasConnectionProfilePath() && !new Path(ProfileSelectionPageHelper.this.getResolvedConnProfilePathControlText()).toFile().exists()) {
                            ProfileSelectionPageHelper.this.setMessage(Messages.profilePage_error_invalidProfileStorePath, 3);
                        }
                        if (ProfileSelectionPageHelper.this.hasConnectionProfilePath() && ProfileSelectionPageHelper.this.m_connectionProfilePath.getData(ProfileSelectionPageHelper.DISABLE_AUTO_SELECT_ITEM) != Boolean.TRUE && (singleProfileItem = ProfileSelectionPageHelper.this.findSingleProfileInTree()) != null) {
                            ProfileSelectionPageHelper.this.m_odaDataSourceTree.setSelection(singleProfileItem);
                            ProfileSelectionPageHelper.this.handleTreeSelection();
                        }
                    }
                });
            }
        });
        MenuButtonProvider provider = new MenuButtonProvider(false);
        this.m_browseButton = new ProfileStoreBrowseButton(composite, 8, provider, this);
        GridData data = new GridData();
        data.widthHint = this.m_browseButton.computeButtonWidth();
        this.m_browseButton.setLayoutData(data);
        if (this.m_wizardPage != null && this.m_wizardPage instanceof ProfileSelectionWizardPage) {
            this.m_hostResourceIdentifiers = ((ProfileSelectionWizardPage)this.m_wizardPage).getHostResourceIdentifiers();
        }
        if (this.m_propertyPage != null && this.m_propertyPage instanceof ProfileSelectionEditorPage) {
            this.m_hostResourceIdentifiers = ((ProfileSelectionEditorPage)this.m_propertyPage).getHostResourceIdentifiers();
        }
        if (this.m_hostResourceIdentifiers != null) {
            File resourceBase = new File(this.m_hostResourceIdentifiers.getApplResourceBaseURI());
            this.m_browseButton.getMenuButtonProvider().setProperty("ResourceFileDIR", resourceBase);
        }
        this.m_browseButton.getMenuButtonProvider().setProperty("IsCreateProfile", Boolean.FALSE);
        this.m_browseButton.refreshMenuItems();
        this.createNewProfileStoreButton(composite);
    }

    private Button createNewProfileStoreButton(Composite parent) {
        Button newButton = new Button(parent, 8);
        newButton.setText(Messages.profilePage_button_new);
        GridData data = new GridData();
        data.horizontalSpan = 3;
        data.horizontalAlignment = 131072;
        data.widthHint = ProfileSelectionPageHelper.computeButtonWidth(newButton);
        newButton.setLayoutData((Object)data);
        newButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                this.handleNewProfileStore();
            }

            private void handleNewProfileStore() {
                ProfileStoreCreationDialog dlg;
                CreateProfileStoreAction createAction = new CreateProfileStoreAction(ProfileSelectionPageHelper.this.getShell(), ProfileSelectionPageHelper.this.m_hostResourceIdentifiers);
                createAction.run();
                if (createAction.isCompleted() && (dlg = createAction.getProfileStoreCreationDialog()) != null && dlg.getFile() != null) {
                    String profileStoreTextPath = DesignUtil.convertFileToResourcePath((File)dlg.getFile(), (ResourceIdentifiers)ProfileSelectionPageHelper.this.m_hostResourceIdentifiers, (boolean)dlg.isProfileStorePathRelative());
                    ProfileSelectionPageHelper.this.setConnProfilePathControlText(profileStoreTextPath, false);
                }
            }
        });
        return newButton;
    }

    private void setupTreeViewer(Composite composite) {
        this.m_odaDataSourceTree = new Tree(composite, 2564);
        this.m_odaDataSourceTree.setLayout((Layout)new GridLayout());
        GridData layoutData = new GridData(1808);
        layoutData.horizontalSpan = 3;
        this.m_odaDataSourceTree.setLayoutData((Object)layoutData);
        this.m_odaDataSourceTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ProfileSelectionPageHelper.this.handleTreeSelection();
            }
        });
        this.populateTree();
    }

    private void handleTreeSelection() {
        TreeItem item = this.getSelectedProfileItem();
        if (item == null) {
            this.clearSelectedProfile();
            this.setSelectedDataSourceName(EMPTY_STRING);
            this.setExternalLinkOption(null);
            this.setDefaultMessageAsError(true);
        } else {
            this.m_profileID = item.getData().toString();
            this.m_odaDataSourceID = this.getProfileItemDataSourceId(item);
            this.setSelectedDataSourceName(item.getText());
            this.setExternalLinkOption(this.m_odaDataSourceID);
            if (this.getMessageType() == 0) {
                this.setDefaultMessageAsError(false);
            }
        }
    }

    private String getProfileItemDataSourceId(TreeItem item) {
        return this.getActiveDataSourceId(item.getParentItem().getData().toString());
    }

    private void setSelectedDataSourceName(String name) {
        if (this.m_dataSourceDesignNameControl == null) {
            return;
        }
        String trimmedName = name.trim();
        this.m_dataSourceDesignNameControl.setText(trimmedName);
    }

    private void setExternalLinkOption(String odaDataSourceId) {
        boolean isExternalLinkOptional = this.isExternalLinkOptional(odaDataSourceId);
        this.setExternalLinkOptionControl(isExternalLinkOptional);
    }

    private boolean isExternalLinkOptional(String odaDataSourceId) {
        OdaProfileCategoryInfo categoryInfo = this.getOdaProfileCategoryInfo(odaDataSourceId);
        return categoryInfo != null ? categoryInfo.isExternalLinkOptional() : true;
    }

    boolean requiresExternalProfileLink() {
        if (!this.hasSelectedProfile()) {
            return false;
        }
        return !this.isExternalLinkOptional(this.m_odaDataSourceID);
    }

    private boolean hasSelectedProfile() {
        return this.m_profileID != null && this.m_odaDataSourceID != null;
    }

    private void clearSelectedProfile() {
        this.m_profileID = null;
        this.m_odaDataSourceID = null;
    }

    private void setDataSourceDesignName(String name) {
        if (this.inEditMode()) {
            return;
        }
        assert (name != null);
        this.m_dataSourceDesignName = name.trim();
    }

    private void populateTree() {
        this.resetTreeViewer();
        if (!this.hasConnectionProfilePath()) {
            return;
        }
        OdaProfileExplorer.getInstance().refresh();
        SortedSet<OdaProfileCategoryInfo> odaCategoryInfoSet = this.getOdaCategoryInfoSet();
        TreeItem odaRoot = null;
        for (OdaProfileCategoryInfo categoryInfo : odaCategoryInfoSet) {
            TreeItem categoryItem = this.createCategoryTreeItems(this.m_odaDataSourceTree, odaRoot, categoryInfo);
            if (categoryItem == null) continue;
            if (odaRoot == null && categoryInfo.hasOdaParentCategory()) {
                odaRoot = categoryItem.getParentItem();
            }
            categoryItem.setExpanded(true);
            this.m_odaDataSourceTree.showItem(categoryItem);
        }
        if (this.m_odaDataSourceTree.getItemCount() == 0) {
            this.createOdaRootItem(this.m_odaDataSourceTree);
        }
    }

    private void resetTreeViewer() {
        if (this.m_odaDataSourceTree != null) {
            this.m_odaDataSourceTree.removeAll();
        }
    }

    private TreeItem getSelectedProfileItem() {
        TreeItem[] items = this.m_odaDataSourceTree.getSelection();
        if (items.length == 0) {
            return null;
        }
        TreeItem item = items[0];
        if (item.getParentItem() == null || item.getItemCount() > 0) {
            return null;
        }
        return item;
    }

    private TreeItem findProfileInTree(String odaDataSourceId, String profileId) {
        if (profileId == null) {
            return null;
        }
        TreeItem dsCategory = this.findOdaCategoryInTree(odaDataSourceId);
        TreeItem profileItem = this.findProfileInCategoryItem(dsCategory, profileId);
        if (profileItem != null) {
            return profileItem;
        }
        Set<String> deprecatedIds = this.getDeprecatedDataSourceIds(odaDataSourceId);
        for (String deprecatedId : deprecatedIds) {
            dsCategory = this.findOdaCategoryInTree(deprecatedId);
            profileItem = this.findProfileInCategoryItem(dsCategory, profileId);
            if (profileItem == null) continue;
            return profileItem;
        }
        return null;
    }

    private TreeItem findProfileInCategoryItem(TreeItem dsCategory, String profileId) {
        if (dsCategory == null) {
            return null;
        }
        TreeItem[] profileItems = dsCategory.getItems();
        int i = 0;
        while (i < profileItems.length) {
            TreeItem profileItem = profileItems[i];
            if (profileItem.getData().toString().equals(profileId)) {
                return profileItem;
            }
            ++i;
        }
        return null;
    }

    private TreeItem findOdaCategoryInTree(String odaDataSourceId) {
        if (this.m_odaDataSourceTree == null || odaDataSourceId == null) {
            return null;
        }
        TreeItem[] topItems = this.m_odaDataSourceTree.getItems();
        if (topItems.length == 0) {
            return null;
        }
        int i = 0;
        while (i < topItems.length) {
            TreeItem topLevelItem = topItems[i];
            if (this.isOdaCategoryItem(topLevelItem, odaDataSourceId)) {
                return topLevelItem;
            }
            TreeItem[] subCategories = topLevelItem.getItems();
            int j = 0;
            while (j < subCategories.length) {
                TreeItem subCategory = subCategories[j];
                if (this.isOdaCategoryItem(subCategory, odaDataSourceId)) {
                    return subCategory;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    private boolean isOdaCategoryItem(TreeItem item, String odaDataSourceId) {
        if (item.getItemCount() == 0) {
            return false;
        }
        return item.getData() != null && item.getData().toString().equals(odaDataSourceId);
    }

    private TreeItem findSingleProfileInTree() {
        if (this.m_odaDataSourceTree == null || this.m_odaDataSourceTree.getItemCount() != 1) {
            return null;
        }
        TreeItem topLevelItem = this.m_odaDataSourceTree.getItems()[0];
        if (topLevelItem.getItemCount() != 1) {
            return null;
        }
        TreeItem secondLevelItem = topLevelItem.getItems()[0];
        if (secondLevelItem.getItemCount() > 1) {
            return null;
        }
        if (secondLevelItem.getItemCount() == 0) {
            return secondLevelItem;
        }
        return secondLevelItem.getItems()[0];
    }

    private SortedSet<OdaProfileCategoryInfo> getOdaCategoryInfoSet() {
        if (this.m_dataSourceIDs == null) {
            this.m_dataSourceIDs = this.createOdaProfileCategoryInfoSet();
        }
        return this.m_dataSourceIDs;
    }

    private SortedSet<OdaProfileCategoryInfo> createOdaProfileCategoryInfoSet() {
        ManifestExplorer.Filter profileTypeFilter = ManifestExplorer.createFilter();
        profileTypeFilter.setMissingDataSetTypesFilter(true);
        profileTypeFilter.setDeprecatedFilter(false);
        profileTypeFilter.setHideWrapper(false);
        ExtensionManifest[] odaManifests = ManifestExplorer.getInstance().getExtensionManifests(profileTypeFilter);
        this.m_deprecatedDataSourceMap.clear();
        TreeSet<OdaProfileCategoryInfo> sortedSet = new TreeSet<OdaProfileCategoryInfo>();
        ExtensionManifest[] extensionManifestArray = odaManifests;
        int n = odaManifests.length;
        int n2 = 0;
        while (n2 < n) {
            ExtensionManifest manifest = extensionManifestArray[n2];
            String odaDataSourceId = manifest.getDataSourceElementID();
            String relatedDataSourceId = manifest.getRelatedDataSourceId();
            if (manifest.isDeprecated()) {
                this.m_deprecatedDataSourceMap.put(odaDataSourceId, relatedDataSourceId);
            }
            if (this.m_treeFilter == null || this.m_treeFilter.equals(odaDataSourceId) || this.m_treeFilter.equals(relatedDataSourceId)) {
                sortedSet.add(new OdaProfileCategoryInfo(odaDataSourceId, manifest));
            }
            ++n2;
        }
        return sortedSet;
    }

    private String getActiveDataSourceId(String odaDataSourceId) {
        return this.m_deprecatedDataSourceMap.containsKey(odaDataSourceId) ? this.m_deprecatedDataSourceMap.get(odaDataSourceId) : odaDataSourceId;
    }

    private Set<String> getDeprecatedDataSourceIds(String odaDataSourceId) {
        if (!this.m_deprecatedDataSourceMap.containsValue(odaDataSourceId)) {
            return Collections.emptySet();
        }
        HashSet<String> deprecatedIds = new HashSet<String>();
        for (Map.Entry<String, String> deprecatedEntry : this.m_deprecatedDataSourceMap.entrySet()) {
            if (!deprecatedEntry.getValue().equals(odaDataSourceId)) continue;
            deprecatedIds.add(deprecatedEntry.getKey());
        }
        return deprecatedIds;
    }

    private OdaProfileCategoryInfo getOdaProfileCategoryInfo(String odaDataSourceId) {
        if (odaDataSourceId == null) {
            return null;
        }
        SortedSet<OdaProfileCategoryInfo> odaCategoryInfoSet = this.getOdaCategoryInfoSet();
        for (OdaProfileCategoryInfo categoryInfo : odaCategoryInfoSet) {
            if (!odaDataSourceId.equals(categoryInfo.getOdaDataSourceId())) continue;
            return categoryInfo;
        }
        return null;
    }

    private Map<String, String> getProfileIdentifiersByCategory(String categoryId) {
        try {
            return OdaProfileExplorer.getInstance().getProfileIdsAndNamesByCategory(categoryId, new Path(this.getResolvedConnProfilePathControlText()).toFile());
        }
        catch (OdaException odaException) {
            this.setMessage(Messages.profilePage_error_invalidProfileStorePath, 3);
            return null;
        }
    }

    private TreeItem createOdaRootItem(Tree parent) {
        TreeItem odaRoot = new TreeItem(parent, 0);
        odaRoot.setText(Messages.profilePage_odaTreeName);
        return odaRoot;
    }

    private TreeItem createCategoryTreeItems(Tree parent, TreeItem parentItem, OdaProfileCategoryInfo categoryInfo) {
        String categoryId = categoryInfo.getEffectiveCategoryId();
        Map<String, String> profileIds = this.getProfileIdentifiersByCategory(categoryId);
        if (profileIds == null || profileIds.isEmpty()) {
            return null;
        }
        if (categoryInfo.hasOdaParentCategory()) {
            if (parentItem == null) {
                parentItem = this.createOdaRootItem(parent);
            }
        } else {
            parentItem = null;
        }
        TreeItem categoryItem = parentItem != null ? new TreeItem(parentItem, 0) : new TreeItem(parent, 0);
        categoryItem.setData((Object)categoryInfo.getOdaDataSourceId());
        categoryItem.setText(categoryInfo.getDisplayName());
        this.createChildTreeItems(categoryItem, profileIds, 0);
        return categoryItem;
    }

    private void createChildTreeItems(TreeItem parentItem, Map<String, String> profileIds, int style) {
        if (profileIds == null) {
            return;
        }
        for (String profileInstanceId : profileIds.keySet()) {
            TreeItem item = new TreeItem(parentItem, style);
            item.setData((Object)profileInstanceId);
            item.setText(profileIds.get(profileInstanceId));
        }
    }

    private void setupDataSourceName(Composite composite) {
        GridData layoutData = new GridData(768);
        layoutData.horizontalSpan = 3;
        this.m_useDefaultDSNameCheckBox = new Button(composite, 32);
        this.m_useDefaultDSNameCheckBox.setText(Messages.profilePage_checkboxLabel_useDefaultName);
        this.m_useDefaultDSNameCheckBox.setSelection(true);
        this.m_useDefaultDSNameCheckBox.setLayoutData((Object)layoutData);
        this.m_useDefaultDSNameCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TreeItem item;
                if (ProfileSelectionPageHelper.this.m_useDefaultDSNameCheckBox.getSelection() && (item = ProfileSelectionPageHelper.this.getSelectedProfileItem()) != null) {
                    ProfileSelectionPageHelper.this.setSelectedDataSourceName(item.getText());
                }
                ProfileSelectionPageHelper.this.enableDataSourceNameEditor(!ProfileSelectionPageHelper.this.m_useDefaultDSNameCheckBox.getSelection());
            }
        });
        this.m_dataSourceNameLabel = new Label(composite, 0);
        this.m_dataSourceNameLabel.setText(Messages.profilePage_label_dataSourceName);
        this.m_dataSourceNameLabel.setLayoutData((Object)new GridData(32));
        layoutData = new GridData(768);
        layoutData.horizontalSpan = 2;
        this.m_dataSourceDesignNameControl = new Text(composite, 2048);
        this.m_dataSourceDesignNameControl.setLayoutData((Object)layoutData);
        this.m_dataSourceDesignNameControl.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ProfileSelectionPageHelper.this.setDataSourceDesignName(ProfileSelectionPageHelper.this.m_dataSourceDesignNameControl.getText());
                String invalidMessage = null;
                if (ProfileSelectionPageHelper.this.isDesignNameBlank()) {
                    ProfileSelectionPageHelper.this.setPageComplete(false);
                    ProfileSelectionPageHelper.this.setMessage(Messages.profilePage_error_emptyName, 3);
                } else {
                    invalidMessage = ProfileSelectionPageHelper.this.validateAndGetErrorMessage();
                    if (invalidMessage != null) {
                        ProfileSelectionPageHelper.this.setPageComplete(false);
                        ProfileSelectionPageHelper.this.setMessage(invalidMessage, 3);
                    } else {
                        boolean isNameOk = ProfileSelectionPageHelper.this.inEditMode() ? true : ProfileSelectionPageHelper.this.hasSelectedProfile();
                        ProfileSelectionPageHelper.this.setPageComplete(isNameOk);
                    }
                }
            }
        });
        this.enableDataSourceNameEditor(false);
    }

    private void setupLinkCheckBox(Composite composite) {
        this.m_linkRefCheckBox = new Button(composite, 32);
        this.m_linkRefCheckBox.setToolTipText(Messages.profilePage_checkboxTooltip_maintainLink);
        GridData data = new GridData();
        data.horizontalSpan = 3;
        this.m_linkRefCheckBox.setLayoutData((Object)data);
        this.m_linkRefCheckBox.setText(Messages.profilePage_checkboxLabel_maintainLink);
        this.m_linkRefCheckBox.setSelection(true);
        this.setExternalLinkDefaultState();
        this.m_linkRefCheckBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!ProfileSelectionPageHelper.this.inEditMode() || ProfileSelectionPageHelper.this.m_odaDataSourceTree == null) {
                    return;
                }
                boolean maintainLink = ProfileSelectionPageHelper.this.m_linkRefCheckBox.getSelection();
                ProfileSelectionPageHelper.this.m_odaDataSourceTree.setEnabled(maintainLink);
                if (ProfileSelectionPageHelper.this.isPageComplete()) {
                    ProfileSelectionPageHelper.this.setMessage(ProfileSelectionPageHelper.EMPTY_STRING, 0);
                } else {
                    ProfileSelectionPageHelper.this.setDefaultMessageAsError(maintainLink);
                }
            }
        });
    }

    private boolean isDesignNameBlank() {
        return this.m_dataSourceDesignName == null || this.m_dataSourceDesignName.length() == 0;
    }

    private String validateAndGetErrorMessage() {
        if (this.m_designNameValidator != null) {
            block4: {
                try {
                    if (!this.m_designNameValidator.isValid(this.m_dataSourceDesignName)) break block4;
                    return null;
                }
                catch (OdaException ex) {
                    return ex.getMessage();
                }
            }
            return Messages.profilePage_error_invalidName;
        }
        return null;
    }

    private void enableDataSourceNameEditor(boolean enabled) {
        this.m_dataSourceNameLabel.setEnabled(enabled);
        this.m_dataSourceDesignNameControl.setEnabled(enabled);
    }

    private void setDataSourceNameEditorVisible(boolean visible) {
        this.m_useDefaultDSNameCheckBox.setVisible(visible);
        this.m_dataSourceNameLabel.setVisible(visible);
        this.m_dataSourceDesignNameControl.setVisible(visible);
    }

    private void setExternalLinkOptionControl(boolean isExternalLinkOptional) {
        this.m_linkRefCheckBox.setEnabled(isExternalLinkOptional);
        if (!isExternalLinkOptional) {
            this.m_linkRefCheckBox.setSelection(true);
        }
    }

    private void setExternalLinkDefaultState() {
        this.m_linkRefCheckBox.setEnabled(this.hasConnectionProfilePath());
    }

    private boolean inEditMode() {
        return this.m_propertyPage != null;
    }

    private boolean hasConnectionProfilePath() {
        return this.getConnProfilePathControlText().trim().length() > 0;
    }

    private void setConnProfilePathControlText(String text, boolean disableAutoSelect) {
        String localizedText = TextProcessorWrapper.process(text);
        if (disableAutoSelect) {
            this.m_connectionProfilePath.setData(DISABLE_AUTO_SELECT_ITEM, (Object)Boolean.TRUE);
        }
        this.m_connectionProfilePath.setText(localizedText);
        this.m_connectionProfilePath.setData(DISABLE_AUTO_SELECT_ITEM, null);
    }

    private String getConnProfilePathControlText() {
        String localizedText = this.m_connectionProfilePath.getText();
        return TextProcessorWrapper.deprocess(localizedText);
    }

    private String getResolvedConnProfilePathControlText() {
        return this.resolveProfileStorePath(this.getConnProfilePathControlText());
    }

    private String resolveProfileStorePath(String filePathText) {
        if (filePathText == null || filePathText.trim().length() == 0 || this.m_hostResourceIdentifiers == null) {
            return filePathText;
        }
        String resolvedFilePathText = DesignUtil.resolveToApplResourcePath((String)filePathText, (ResourceIdentifiers)this.m_hostResourceIdentifiers);
        return resolvedFilePathText != null ? resolvedFilePathText : filePathText;
    }

    @Override
    public void setProfileStorePath(String path, boolean isRelative) {
        if (path == null) {
            path = EMPTY_STRING;
        }
        this.setConnProfilePathControlText(path, false);
    }

    @Override
    public void browseSelected() {
        this.m_browseButton.getMenuButtonProvider().setProperty("StoredPath", this.getResolvedConnProfilePathControlText());
    }

    static int computeButtonWidth(Button button) {
        int defaultWidth = button.computeSize((int)-1, (int)-1).x;
        return defaultWidth < 80 ? 80 : defaultWidth;
    }

    private class OdaProfileCategoryInfo
    implements Comparable {
        private String m_odaDataSourceId;
        private boolean m_hasOdaParentCategory;
        private String m_categoryDisplayName;
        private String m_effectiveCategoryId;

        OdaProfileCategoryInfo(String id, ExtensionManifest manifest) {
            this.m_odaDataSourceId = id;
            ICategory profileCategory = ProfileCategoryUtil.getCategory((String)this.m_odaDataSourceId);
            this.m_hasOdaParentCategory = ProfileCategoryUtil.hasODAParentCategory((ICategory)profileCategory);
            boolean useParentCategory = !this.m_hasOdaParentCategory;
            this.m_categoryDisplayName = this.getEffectiveDisplayName(profileCategory, useParentCategory, manifest);
            this.m_effectiveCategoryId = this.getEffectiveCategoryId(profileCategory, useParentCategory);
        }

        private String getEffectiveDisplayName(ICategory profileCategory, boolean useParentCategory, ExtensionManifest manifest) {
            String categoryDisplayName = this.getCategoryDisplayName(profileCategory, useParentCategory, manifest.getDataSourceDisplayName());
            return useParentCategory ? categoryDisplayName : this.refineDisplayName(categoryDisplayName, manifest);
        }

        private String getCategoryDisplayName(ICategory profileCategory, boolean useParentCategory, String defaultDisplayName) {
            String displayName;
            if (profileCategory == null) {
                return defaultDisplayName;
            }
            if (useParentCategory && profileCategory.getParent() != null) {
                profileCategory = profileCategory.getParent();
            }
            if ((displayName = profileCategory.getName()) == null || displayName.length() == 0 || ProfileCategoryUtil.isUnknownCategory((ICategory)profileCategory)) {
                displayName = defaultDisplayName;
            }
            return displayName;
        }

        private String refineDisplayName(String categoryDisplayName, ExtensionManifest manifest) {
            if (!manifest.isDeprecated()) {
                return categoryDisplayName;
            }
            String replacingDataSourceId = manifest.getRelatedDataSourceId();
            try {
                String newDisplayName = ManifestExplorer.getInstance().getExtensionManifest(replacingDataSourceId).getDataSourceDisplayName();
                categoryDisplayName = Messages.bind((String)Messages.profilePage_deprecatedProfileDisplayName, (Object)categoryDisplayName, (Object)newDisplayName);
            }
            catch (OdaException odaException) {}
            return categoryDisplayName;
        }

        private String getEffectiveCategoryId(ICategory profileCategory, boolean useParentCategory) {
            String categoryId = null;
            if (profileCategory != null) {
                if (useParentCategory && profileCategory.getParent() != null) {
                    profileCategory = profileCategory.getParent();
                }
                categoryId = profileCategory.getId();
            }
            if (ProfileCategoryUtil.isUnknownCategory(categoryId)) {
                categoryId = this.m_odaDataSourceId;
            }
            return categoryId;
        }

        String getOdaDataSourceId() {
            return this.m_odaDataSourceId;
        }

        boolean hasOdaParentCategory() {
            return this.m_hasOdaParentCategory;
        }

        String getDisplayName() {
            return this.m_categoryDisplayName;
        }

        String getEffectiveCategoryId() {
            return this.m_effectiveCategoryId;
        }

        boolean isExternalLinkOptional() {
            return this.hasOdaParentCategory() || this.getEffectiveCategoryId().equals("org.eclipse.datatools.connectivity.db.category");
        }

        public int compareTo(Object obj) {
            if (!(obj instanceof OdaProfileCategoryInfo)) {
                return -1;
            }
            return this.compareTo((OdaProfileCategoryInfo)obj);
        }

        public int compareTo(OdaProfileCategoryInfo anotherId) {
            if (this.m_hasOdaParentCategory != anotherId.m_hasOdaParentCategory) {
                return !this.m_hasOdaParentCategory ? -1 : 1;
            }
            int result = this.m_categoryDisplayName.compareTo(anotherId.m_categoryDisplayName);
            if (result != 0) {
                return result;
            }
            return this.m_odaDataSourceId.compareTo(anotherId.m_odaDataSourceId);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof OdaProfileCategoryInfo)) {
                return false;
            }
            OdaProfileCategoryInfo anotherId = (OdaProfileCategoryInfo)obj;
            return this.m_categoryDisplayName.equals(anotherId.m_categoryDisplayName) && this.m_odaDataSourceId.equals(anotherId.m_odaDataSourceId) && this.m_hasOdaParentCategory == anotherId.m_hasOdaParentCategory && this.m_effectiveCategoryId.equals(anotherId.m_effectiveCategoryId);
        }
    }
}

