/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.validators;

import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.DimensionHandle;
import org.eclipse.birt.report.model.api.GraphicMasterPageHandle;
import org.eclipse.birt.report.model.api.validators.IValidationListener;
import org.eclipse.birt.report.model.api.validators.MasterPageMultiColumnValidator;
import org.eclipse.birt.report.model.metadata.MetaDataDictionary;
import org.eclipse.birt.report.model.validators.ValidatorTestCase;

public class MasterPageMultiColumnValidatorTest
extends ValidatorTestCase {
    ValidatorTestCase.MyListener listener = new ValidatorTestCase.MyListener(this);

    public void testTriggers() throws Exception {
        this.createDesign();
        MetaDataDictionary.getInstance().setUseValidationTrigger(true);
        GraphicMasterPageHandle pageHandle = this.designHandle.getElementFactory().newGraphicMasterPage("masterPage1");
        this.designHandle.addValidationListener((IValidationListener)this.listener);
        this.designHandle.getMasterPages().add((DesignElementHandle)pageHandle);
        MasterPageMultiColumnValidatorTest.assertFalse((boolean)this.listener.hasError((DesignElementHandle)pageHandle, MasterPageMultiColumnValidator.getInstance().getName(), "Error.SemanticError.INVALID_MULTI_COLUMN"));
        pageHandle.setPageType("custom");
        DimensionHandle height = pageHandle.getHeight();
        height.setStringValue("15in");
        DimensionHandle width = pageHandle.getWidth();
        width.setStringValue("10in");
        pageHandle.setColumnCount(3);
        MasterPageMultiColumnValidatorTest.assertFalse((boolean)this.listener.hasError((DesignElementHandle)pageHandle, MasterPageMultiColumnValidator.getInstance().getName(), "Error.SemanticError.INVALID_MULTI_COLUMN"));
        DimensionHandle columnSpacing = pageHandle.getColumnSpacing();
        columnSpacing.setStringValue("6in");
        MasterPageMultiColumnValidatorTest.assertTrue((boolean)this.listener.hasError((DesignElementHandle)pageHandle, MasterPageMultiColumnValidator.getInstance().getName(), "Error.SemanticError.INVALID_MULTI_COLUMN"));
        columnSpacing.setStringValue("1in");
        MasterPageMultiColumnValidatorTest.assertFalse((boolean)this.listener.hasError((DesignElementHandle)pageHandle, MasterPageMultiColumnValidator.getInstance().getName(), "Error.SemanticError.INVALID_MULTI_COLUMN"));
    }
}

