/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.ErrorDetail;
import org.eclipse.birt.report.model.api.Expression;
import org.eclipse.birt.report.model.api.FilterConditionHandle;
import org.eclipse.birt.report.model.api.GroupHandle;
import org.eclipse.birt.report.model.api.ListGroupHandle;
import org.eclipse.birt.report.model.api.ListHandle;
import org.eclipse.birt.report.model.api.SortKeyHandle;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.core.MultiElementSlot;
import org.eclipse.birt.report.model.elements.FreeForm;
import org.eclipse.birt.report.model.elements.ListGroup;
import org.eclipse.birt.report.model.elements.ListItem;
import org.eclipse.birt.report.model.parser.ParserTestCase;

public class ListItemParseTest
extends ParserTestCase {
    String fileName = "ListItemParseTest.xml";
    String outFileName = "ListItemParseTest_out.xml";
    String goldenFileName = "ListItemParseTest_golden.xml";
    String semanticCheckFileName = "ListItemParseTest_1.xml";

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.openDesign(this.fileName);
    }

    public void testParser() throws Exception {
        ListItem list = (ListItem)this.design.findElement("My List");
        ListItemParseTest.assertNotNull((Object)list);
        ListHandle listHandle = list.handle((Module)this.design);
        ListItemParseTest.assertEquals((String)"my list on create", (String)listHandle.getOnCreate());
        ListItemParseTest.assertEquals((String)"my list on prepare", (String)listHandle.getOnPrepare());
        ListItemParseTest.assertEquals((String)"my list on render", (String)listHandle.getOnRender());
        ListItemParseTest.assertEquals((String)"my list on page break", (String)listHandle.getOnPageBreak());
        ListItemParseTest.assertEquals((String)"Sect", (String)listHandle.getTagType());
        ListItemParseTest.assertEquals((String)"English", (String)listHandle.getLanguage());
        ListItemParseTest.assertEquals((String)"Alt Text", (String)listHandle.getAltTextExpression().getStringExpression());
        ListItemParseTest.assertEquals((int)120, (int)listHandle.getPageBreakInterval());
        Iterator sortKeys = listHandle.sortsIterator();
        SortKeyHandle sortKeyHandle = (SortKeyHandle)sortKeys.next();
        ListItemParseTest.assertEquals((String)"age", (String)sortKeyHandle.getKey());
        ListItemParseTest.assertEquals((String)"asc", (String)sortKeyHandle.getDirection());
        sortKeyHandle = (SortKeyHandle)sortKeys.next();
        ListItemParseTest.assertEquals((String)"grade", (String)sortKeyHandle.getKey());
        ListItemParseTest.assertEquals((String)"desc", (String)sortKeyHandle.getDirection());
        ListItemParseTest.assertNull(sortKeys.next());
        Iterator filters = listHandle.filtersIterator();
        FilterConditionHandle filterHandle = (FilterConditionHandle)filters.next();
        ListItemParseTest.assertEquals((String)"lt", (String)filterHandle.getOperator());
        ListItemParseTest.assertEquals((String)"filter expression", (String)filterHandle.getExpr());
        ListItemParseTest.assertEquals((String)"value1 expression", (String)filterHandle.getValue1());
        ListItemParseTest.assertEquals((String)"value2 expression", (String)filterHandle.getValue2());
        MultiElementSlot header = (MultiElementSlot)list.getSlot(0);
        FreeForm form = (FreeForm)header.getContent(0);
        ListItemParseTest.assertEquals((String)"Header Section", (String)form.getStringProperty((Module)this.design, "comments"));
        MultiElementSlot detail = (MultiElementSlot)list.getSlot(2);
        form = (FreeForm)detail.getContent(0);
        ListItemParseTest.assertEquals((String)"Detail Section", (String)form.getStringProperty((Module)this.design, "comments"));
        MultiElementSlot footer = (MultiElementSlot)list.getSlot(3);
        form = (FreeForm)footer.getContent(0);
        ListItemParseTest.assertEquals((String)"Footer Section", (String)form.getStringProperty((Module)this.design, "comments"));
        MultiElementSlot groupSlot = (MultiElementSlot)list.getSlot(1);
        ListGroup group = (ListGroup)groupSlot.getContent(0);
        ListGroupHandle groupHandle = (ListGroupHandle)group.getHandle((Module)this.design);
        ListItemParseTest.assertEquals((String)"2005/05/20", (String)groupHandle.getGroupStart());
        ListItemParseTest.assertEquals((String)"2005 statistics", (String)groupHandle.getTocExpression());
        ListItemParseTest.assertTrue((boolean)groupHandle.hideDetail());
        ListItemParseTest.assertFalse((boolean)groupHandle.showDetailFilter());
        filters = groupHandle.filtersIterator();
        filterHandle = (FilterConditionHandle)filters.next();
        ListItemParseTest.assertEquals((String)"lt", (String)filterHandle.getOperator());
        ListItemParseTest.assertEquals((String)"filter expression", (String)filterHandle.getExpr());
        ListItemParseTest.assertEquals((String)"value1 expression", (String)filterHandle.getValue1());
        ListItemParseTest.assertEquals((String)"value2 expression", (String)filterHandle.getValue2());
        header = (MultiElementSlot)group.getSlot(0);
        form = (FreeForm)header.getContent(0);
        ListItemParseTest.assertEquals((String)"Group Header Section", (String)form.getStringProperty((Module)this.design, "comments"));
        footer = (MultiElementSlot)group.getSlot(1);
        form = (FreeForm)footer.getContent(0);
        ListItemParseTest.assertEquals((String)"Group Footer Section", (String)form.getStringProperty((Module)this.design, "comments"));
        ListItemParseTest.assertEquals((String)"week", (String)groupHandle.getInterval());
        ListItemParseTest.assertTrue((3.0 == groupHandle.getIntervalRange() ? 1 : 0) != 0);
        ListItemParseTest.assertEquals((String)"desc", (String)groupHandle.getSortDirection());
        ListItemParseTest.assertEquals((String)"complex-sort", (String)groupHandle.getSortType());
        ListItemParseTest.assertEquals((String)"[Country]", (String)groupHandle.getKeyExpr());
        ListItemParseTest.assertEquals((String)"group test", (String)groupHandle.getName());
        ListItemParseTest.assertEquals((String)"create", (String)groupHandle.getOnCreate());
        ListItemParseTest.assertEquals((String)"prepare", (String)groupHandle.getOnPrepare());
        ListItemParseTest.assertEquals((String)"render", (String)groupHandle.getOnRender());
        ListItemParseTest.assertEquals((String)"page break", (String)groupHandle.getOnPageBreak());
        sortKeys = groupHandle.sortsIterator();
        sortKeyHandle = (SortKeyHandle)sortKeys.next();
        ListItemParseTest.assertEquals((String)"name", (String)sortKeyHandle.getKey());
        ListItemParseTest.assertEquals((String)"asc", (String)sortKeyHandle.getDirection());
        sortKeyHandle = (SortKeyHandle)sortKeys.next();
        ListItemParseTest.assertEquals((String)"birthday", (String)sortKeyHandle.getKey());
        ListItemParseTest.assertEquals((String)"desc", (String)sortKeyHandle.getDirection());
        ListItemParseTest.assertEquals((String)"\"bookmark\"", (String)groupHandle.getBookmark());
        ListItem list2 = (ListItem)this.design.findElement("My List2");
        ListHandle list2Handle = list2.handle((Module)this.design);
        ListItemParseTest.assertEquals((String)"sect", (String)list2Handle.getTagType());
    }

    public void testWriter() throws Exception {
        ListHandle listHandle = (ListHandle)this.designHandle.findElement("My List");
        ListItemParseTest.assertNotNull((Object)listHandle);
        listHandle.setOnPrepare("new prepare on the list");
        listHandle.setOnCreate("new create on the list");
        listHandle.setOnRender(null);
        listHandle.setPageBreakInterval(100);
        listHandle.setOnPageBreak("new list page break");
        listHandle.setTagType("Sect");
        listHandle.setLanguage("English");
        listHandle.setAltTextExpression(new Expression((Object)"Alt Text", "constant"));
        GroupHandle groupHandle = (GroupHandle)listHandle.getGroups().get(0);
        groupHandle.setGroupStart("2006/01/01");
        groupHandle.setTocExpression("toc1");
        groupHandle.setSortType("none");
        groupHandle.setOnPageBreak("new page break");
        groupHandle.setOnCreate("new create");
        groupHandle.setOnRender("new render");
        groupHandle.setShowDetailFilter(true);
        ListItemParseTest.assertEquals((String)"\"bookmark\"", (String)groupHandle.getBookmark());
        groupHandle.setBookmark("\"newbookmark\"");
        this.save();
        ListItemParseTest.assertTrue((boolean)this.compareFile(this.goldenFileName));
    }

    public void testSemanticCheck() throws Exception {
        this.openDesign(this.semanticCheckFileName);
        List errors = this.design.getErrorList();
        int i = 0;
        ListItemParseTest.assertEquals((int)4, (int)errors.size());
        ErrorDetail error = (ErrorDetail)errors.get(i++);
        ListItemParseTest.assertEquals((String)"My First Table", (String)error.getElement().getName());
        ListItemParseTest.assertEquals((String)"Error.ContentException.INVALID_CONTEXT_CONTAINMENT", (String)error.getErrorCode());
        error = (ErrorDetail)errors.get(i++);
        ListItemParseTest.assertEquals((String)"My First List", (String)error.getElement().getName());
        ListItemParseTest.assertEquals((String)"Error.PropertyValueException.VALUE_REQUIRED", (String)error.getErrorCode());
        error = (ErrorDetail)errors.get(i++);
        ListItemParseTest.assertEquals((String)"Second table", (String)error.getElement().getName());
        ListItemParseTest.assertEquals((String)"Error.SemanticError.MISSING_DATA_SET", (String)error.getErrorCode());
        error = (ErrorDetail)errors.get(i++);
        ListItemParseTest.assertEquals((String)"Second inner list", (String)error.getElement().getName());
        ListItemParseTest.assertEquals((String)"Error.SemanticError.MISSING_DATA_SET", (String)error.getErrorCode());
    }

    public void testGroupNameSemanticCheck() throws Exception {
        this.openDesign("ListItemParseTest_2.xml");
        List errors = this.design.getErrorList();
        int i = 0;
        ListItemParseTest.assertEquals((int)3, (int)errors.size());
        ErrorDetail error = (ErrorDetail)errors.get(i++);
        ListItemParseTest.assertEquals((Object)"group 2", (Object)error.getElement().getLocalProperty((Module)this.design, "groupName"));
        ListItemParseTest.assertEquals((String)"Error.PropertyValueException.VALUE_REQUIRED", (String)error.getErrorCode());
        error = (ErrorDetail)errors.get(i++);
        ListItemParseTest.assertEquals((Object)"group 5", (Object)error.getElement().getLocalProperty((Module)this.design, "groupName"));
        ListItemParseTest.assertEquals((String)"Error.PropertyValueException.VALUE_REQUIRED", (String)error.getErrorCode());
        error = (ErrorDetail)errors.get(i++);
        ListItemParseTest.assertEquals((Object)"group 4", (Object)error.getElement().getLocalProperty((Module)this.design, "groupName"));
        ListItemParseTest.assertEquals((String)"Error.PropertyValueException.VALUE_REQUIRED", (String)error.getErrorCode());
    }

    public void testPageBreakInterval() throws Exception {
        this.openDesign("ListItemParseTest_3.xml");
        ListItem list = (ListItem)this.design.findElement("My List");
        ListHandle listHandle = list.handle((Module)this.design);
        ListItemParseTest.assertEquals((int)120, (int)listHandle.getPageBreakInterval());
        ListItem list1 = (ListItem)this.design.findElement("My List1");
        listHandle = list1.handle((Module)this.design);
        ListItemParseTest.assertEquals((int)40, (int)listHandle.getPageBreakInterval());
        this.openDesign("ListItemParseTest_4.xml");
        list = (ListItem)this.design.findElement("My List");
        listHandle = list.handle((Module)this.design);
        ListItemParseTest.assertEquals((int)120, (int)listHandle.getPageBreakInterval());
        list1 = (ListItem)this.design.findElement("My List1");
        listHandle = list1.handle((Module)this.design);
        ListItemParseTest.assertEquals((int)40, (int)listHandle.getPageBreakInterval());
    }
}

