/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.parser;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.GridHandle;
import org.eclipse.birt.report.model.api.SlotHandle;
import org.eclipse.birt.report.model.api.command.ContentException;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.GridItem;
import org.eclipse.birt.report.model.elements.Label;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class ComponentScratchPadTest
extends BaseTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testWriter() throws Exception {
        this.openDesign("ComponentScratchPadTest.xml");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.designHandle.serialize((OutputStream)out);
        ByteArrayInputStream is = new ByteArrayInputStream(out.toByteArray());
        this.openDesign("", is);
        ComponentScratchPadTest.assertNotNull((Object)this.design);
        this.save();
        ComponentScratchPadTest.assertTrue((boolean)this.compareFile("ComponentScratchPadTest_golden.xml"));
    }

    public void testParse() throws Exception {
        this.openDesign("ComponentScratchPadTest.xml");
        ComponentScratchPadTest.assertEquals((int)0, (int)this.design.getErrorList().size());
        SlotHandle components = this.designHandle.getComponents();
        ComponentScratchPadTest.assertEquals((int)2, (int)components.getCount());
        GridHandle grid = (GridHandle)components.get(0);
        ComponentScratchPadTest.assertEquals((Object)grid, (Object)components.get(1).getExtends());
        try {
            grid.moveTo((DesignElementHandle)this.designHandle, 6);
            ComponentScratchPadTest.fail();
        }
        catch (ContentException contentException) {
            // empty catch block
        }
        ComponentScratchPadTest.assertEquals((int)2, (int)components.getCount());
        try {
            grid.dropAndClear();
            ComponentScratchPadTest.fail();
        }
        catch (ContentException contentException) {
            // empty catch block
        }
        ComponentScratchPadTest.assertEquals((int)2, (int)components.getCount());
        grid = (GridHandle)components.get(0);
        try {
            this.designHandle.getComponents().shift((DesignElementHandle)grid, 1);
            ComponentScratchPadTest.fail();
        }
        catch (ContentException contentException) {
            // empty catch block
        }
        grid = (GridHandle)components.get(1);
        try {
            this.designHandle.getComponents().shift((DesignElementHandle)grid, 0);
            ComponentScratchPadTest.fail();
        }
        catch (ContentException contentException) {
            // empty catch block
        }
        SlotHandle comHandle = this.designHandle.getComponents();
        GridItem gridItem = new GridItem("grand");
        comHandle.add(gridItem.getHandle((Module)this.design));
        grid = (GridHandle)components.get(0);
        Label labelItem = new Label("label");
        comHandle.add(labelItem.getHandle((Module)this.design));
        gridItem = new GridItem("grid0");
        comHandle.add(gridItem.getHandle((Module)this.design));
        labelItem = new Label("labelParent");
        comHandle.add(labelItem.getHandle((Module)this.design));
        this.design.findElement("grand").setExtendsElement(this.design.findElement("grid0"));
        this.design.findElement("parent").setExtendsElement(this.design.findElement("grand"));
        this.design.findElement("label").setExtendsElement(this.design.findElement("labelParent"));
        this.save();
    }
}

