/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api;

import java.util.List;
import org.eclipse.birt.report.model.api.DesignElementHandle;
import org.eclipse.birt.report.model.api.StructureFactory;
import org.eclipse.birt.report.model.api.TextItemHandle;
import org.eclipse.birt.report.model.api.core.IStructure;
import org.eclipse.birt.report.model.api.elements.structures.HighlightRule;
import org.eclipse.birt.report.model.api.util.StyleUtil;
import org.eclipse.birt.report.model.util.BaseTestCase;

public class StyleUtilTest
extends BaseTestCase {
    public void testCopyStyle() throws Exception {
        this.createDesign();
        TextItemHandle text1 = this.designHandle.getElementFactory().newTextItem("text1");
        TextItemHandle text2 = this.designHandle.getElementFactory().newTextItem("text2");
        this.designHandle.getBody().add((DesignElementHandle)text1);
        this.designHandle.getBody().add((DesignElementHandle)text2);
        HighlightRule highlight = StructureFactory.createHighlightRule();
        highlight.setTestExpression("test");
        text1.setProperty("textAlign", (Object)"center");
        text1.getPropertyHandle("highlightRules").addItem((IStructure)highlight);
        StyleUtil.copyLocalStyles((DesignElementHandle)text1, (DesignElementHandle)text2);
        List highlights = text2.getListProperty("highlightRules");
        StyleUtilTest.assertEquals((int)1, (int)highlights.size());
        StyleUtilTest.assertEquals((Object)highlight, highlights.get(0));
        StyleUtilTest.assertNotSame((Object)highlight, highlights.get(0));
        this.save();
        StyleUtilTest.assertTrue((boolean)this.compareFile("StyleUtilTest_golden.xml"));
        text1.clearProperty("highlightRules");
        highlights = text1.getListProperty("highlightRules");
        StyleUtilTest.assertNull((Object)highlights);
        highlights = text2.getListProperty("highlightRules");
        StyleUtilTest.assertEquals((int)1, (int)highlights.size());
        this.save();
        StyleUtilTest.assertTrue((boolean)this.compareFile("StyleUtilTest_1_golden.xml"));
    }
}

