/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.adapter.oda.api;

import java.util.Iterator;
import org.eclipse.birt.report.model.adapter.oda.impl.ResultSetCriteriaAdapter;
import org.eclipse.birt.report.model.adapter.oda.model.DesignValues;
import org.eclipse.birt.report.model.adapter.oda.model.ModelFactory;
import org.eclipse.birt.report.model.adapter.oda.util.BaseTestCase;
import org.eclipse.birt.report.model.api.OdaDataSetHandle;
import org.eclipse.birt.report.model.api.SortHintHandle;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.datatools.connectivity.oda.design.DataSourceDesign;
import org.eclipse.datatools.connectivity.oda.design.DesignFactory;
import org.eclipse.datatools.connectivity.oda.design.NullOrderingType;
import org.eclipse.datatools.connectivity.oda.design.ResultSetCriteria;
import org.eclipse.datatools.connectivity.oda.design.ResultSetDefinition;
import org.eclipse.datatools.connectivity.oda.design.SortDirectionType;
import org.eclipse.datatools.connectivity.oda.design.SortKey;
import org.eclipse.datatools.connectivity.oda.design.SortSpecification;
import org.eclipse.emf.common.util.EList;

public class ResultSetCriteriaAdapterTest
extends BaseTestCase {
    private DataSetDesign createDataSetDesign() {
        DataSetDesign setDesign = DesignFactory.eINSTANCE.createDataSetDesign();
        setDesign.setOdaExtensionDataSetId("org.eclipse.birt.report.data.oda.jdbc.JdbcSelectDataSet");
        DataSourceDesign dataSource = DesignFactory.eINSTANCE.createDataSourceDesign();
        dataSource.setOdaExtensionDataSourceId("org.eclipse.birt.report.data.oda.jdbc");
        setDesign.setDataSourceDesign(dataSource);
        ResultSetDefinition resultSetDefn = DesignFactory.eINSTANCE.createResultSetDefinition();
        setDesign.setPrimaryResultSet(resultSetDefn);
        return setDesign;
    }

    public void testSortHintFromReportToOda() throws Exception {
        this.openDesign("SortHintTest.xml");
        OdaDataSetHandle setHandle = (OdaDataSetHandle)this.designHandle.findDataSet("MyDataSet");
        DataSetDesign setDesign = this.createDataSetDesign();
        ResultSetCriteriaAdapter adapter = this.createAdapter(setHandle, setDesign);
        adapter.updateODAResultSetCriteria();
        ResultSetDefinition resultSet = setDesign.getPrimaryResultSet();
        EList list = resultSet.getCriteria().getRowOrdering().getSortKeys();
        ResultSetCriteriaAdapterTest.assertEquals((int)3, (int)list.size());
        SortKey key = (SortKey)list.get(0);
        ResultSetCriteriaAdapterTest.assertEquals((String)"sortHint1", (String)key.getColumnName());
        ResultSetCriteriaAdapterTest.assertEquals((int)1, (int)key.getColumnPosition());
        ResultSetCriteriaAdapterTest.assertEquals((Object)SortDirectionType.DESCENDING, (Object)key.getSortDirection());
        ResultSetCriteriaAdapterTest.assertEquals((Object)NullOrderingType.NULLS_FIRST, (Object)key.getNullValueOrdering());
        ResultSetCriteriaAdapterTest.assertTrue((boolean)key.isOptional());
        key = (SortKey)list.get(1);
        ResultSetCriteriaAdapterTest.assertEquals((String)"sortHint2", (String)key.getColumnName());
        ResultSetCriteriaAdapterTest.assertEquals((int)2, (int)key.getColumnPosition());
        ResultSetCriteriaAdapterTest.assertEquals((Object)SortDirectionType.ASCENDING, (Object)key.getSortDirection());
        ResultSetCriteriaAdapterTest.assertEquals((Object)NullOrderingType.NULLS_FIRST, (Object)key.getNullValueOrdering());
        ResultSetCriteriaAdapterTest.assertFalse((boolean)key.isOptional());
        key = (SortKey)list.get(2);
        ResultSetCriteriaAdapterTest.assertEquals((String)"sortHint3", (String)key.getColumnName());
        ResultSetCriteriaAdapterTest.assertEquals((int)3, (int)key.getColumnPosition());
        ResultSetCriteriaAdapterTest.assertEquals((Object)SortDirectionType.DESCENDING, (Object)key.getSortDirection());
        ResultSetCriteriaAdapterTest.assertEquals((Object)NullOrderingType.NULLS_LAST, (Object)key.getNullValueOrdering());
        ResultSetCriteriaAdapterTest.assertTrue((boolean)key.isOptional());
        DesignValues values = ModelFactory.eINSTANCE.createDesignValues();
        values.setResultSets(setDesign.getResultSets());
        this.saveDesignValuesToFile(values);
        ResultSetCriteriaAdapterTest.assertTrue((boolean)this.compareTextFile("SortHintFromReportToOdaTest_golden.xml"));
    }

    public void testEmptySortHintFromReportToOda() throws Exception {
        this.openDesign("EmptySortHintTest.xml");
        OdaDataSetHandle setHandle = (OdaDataSetHandle)this.designHandle.findDataSet("MyDataSet");
        DataSetDesign setDesign = this.createDataSetDesign();
        ResultSetCriteriaAdapterTest.assertNull((Object)setDesign.getPrimaryResultSet().getCriteria().getRowOrdering());
        ResultSetCriteriaAdapter adapter = this.createAdapter(setHandle, setDesign);
        adapter.updateODAResultSetCriteria();
        ResultSetDefinition resultSet = setDesign.getPrimaryResultSet();
        ResultSetCriteriaAdapterTest.assertNotNull((Object)resultSet.getCriteria().getRowOrdering());
    }

    public void testSortHintFromOdaToReport() throws Exception {
        this.openDesign("SortHintTest.xml");
        OdaDataSetHandle setHandle = (OdaDataSetHandle)this.designHandle.findDataSet("MyDataSet");
        DataSetDesign setDesign = this.createTestSortHintDataSetDesign(false);
        ResultSetCriteriaAdapter adapter = this.createAdapter(setHandle, setDesign);
        adapter.updateROMSortAndFilter();
        Iterator iter = setHandle.sortHintsIterator();
        SortHintHandle handle = (SortHintHandle)iter.next();
        ResultSetCriteriaAdapterTest.assertEquals((String)"1", (String)handle.getColumnName());
        ResultSetCriteriaAdapterTest.assertEquals((int)1, (int)handle.getPosition());
        ResultSetCriteriaAdapterTest.assertEquals((String)"nullIsFirst", (String)handle.getNullValueOrdering());
        ResultSetCriteriaAdapterTest.assertEquals((String)"asc", (String)handle.getDirection());
        ResultSetCriteriaAdapterTest.assertFalse((boolean)handle.isOptional());
        handle = (SortHintHandle)iter.next();
        ResultSetCriteriaAdapterTest.assertEquals((String)"2", (String)handle.getColumnName());
        ResultSetCriteriaAdapterTest.assertEquals((int)2, (int)handle.getPosition());
        ResultSetCriteriaAdapterTest.assertEquals((String)"nullIsLast", (String)handle.getNullValueOrdering());
        ResultSetCriteriaAdapterTest.assertEquals((String)"desc", (String)handle.getDirection());
        ResultSetCriteriaAdapterTest.assertTrue((boolean)handle.isOptional());
        this.save();
        ResultSetCriteriaAdapterTest.assertTrue((boolean)this.compareTextFile("SortHintFromOdaToReportTest_golden.xml"));
        adapter = this.createAdapter(setHandle, this.createTestSortHintDataSetDesign(true));
        adapter.updateROMSortAndFilter();
        this.save();
        ResultSetCriteriaAdapterTest.assertTrue((boolean)this.compareTextFile("SortHintFromOdaToReportTest_golden.xml"));
    }

    private DataSetDesign createTestSortHintDataSetDesign(boolean sortSpecIsNull) {
        DataSetDesign setDesign = this.createDataSetDesign();
        if (sortSpecIsNull) {
            return setDesign;
        }
        ResultSetDefinition resultSetDefn = setDesign.getPrimaryResultSet();
        ResultSetCriteria criteria = resultSetDefn.getCriteria();
        SortSpecification sortSpec = criteria.getRowOrdering();
        if (sortSpec == null) {
            sortSpec = DesignFactory.eINSTANCE.createSortSpecification();
            criteria.setRowOrdering(sortSpec);
        }
        EList list = sortSpec.getSortKeys();
        SortKey key = DesignFactory.eINSTANCE.createSortKey();
        key.setColumnName("1");
        key.setColumnPosition(1);
        key.setNullValueOrdering(NullOrderingType.NULLS_FIRST);
        key.setOptional(false);
        key.setSortDirection(SortDirectionType.ASCENDING);
        list.add((Object)key);
        key = DesignFactory.eINSTANCE.createSortKey();
        key.setColumnName("2");
        key.setColumnPosition(2);
        key.setNullValueOrdering(NullOrderingType.NULLS_LAST);
        key.setOptional(true);
        key.setSortDirection(SortDirectionType.DESCENDING);
        list.add((Object)key);
        return setDesign;
    }

    private ResultSetCriteriaAdapter createAdapter(OdaDataSetHandle setHandle, DataSetDesign setDesign) {
        return new ResultSetCriteriaAdapter(setHandle, setDesign, setDesign.getOdaExtensionDataSetId(), true, true);
    }
}

